@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.connectedvmwarevsphere.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * This data object type contains the properties of a SCSI controller device attached to a virtual machine that is reported by the controller.
 * @property busNumber Gets or sets the bus number of the controller.
 * @property controllerKey Gets or sets the key of the controller.
 * @property scsiCtlrUnitNumber Gets or sets the SCSI controller unit number.
 * @property sharing Gets or sets the sharing mode.
 * @property type Gets or sets the controller type.
 */
public data class VirtualSCSIControllerResponse(
    public val busNumber: Int? = null,
    public val controllerKey: Int? = null,
    public val scsiCtlrUnitNumber: Int? = null,
    public val sharing: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.connectedvmwarevsphere.outputs.VirtualSCSIControllerResponse): VirtualSCSIControllerResponse = VirtualSCSIControllerResponse(
            busNumber = javaType.busNumber().map({ args0 -> args0 }).orElse(null),
            controllerKey = javaType.controllerKey().map({ args0 -> args0 }).orElse(null),
            scsiCtlrUnitNumber = javaType.scsiCtlrUnitNumber().map({ args0 -> args0 }).orElse(null),
            sharing = javaType.sharing().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
