@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin

import com.pulumi.azurenative.consumption.ConsumptionFunctions.getBudgetPlain
import com.pulumi.azurenative.consumption.kotlin.inputs.GetBudgetPlainArgs
import com.pulumi.azurenative.consumption.kotlin.inputs.GetBudgetPlainArgsBuilder
import com.pulumi.azurenative.consumption.kotlin.outputs.GetBudgetResult
import com.pulumi.azurenative.consumption.kotlin.outputs.GetBudgetResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ConsumptionFunctions {
    /**
     * Gets the budget for the scope by budget name.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-12-30-preview, 2018-10-01, 2019-05-01, 2019-06-01, 2023-11-01.
     * @param argument null
     * @return A budget resource.
     */
    public suspend fun getBudget(argument: GetBudgetPlainArgs): GetBudgetResult =
        toKotlin(getBudgetPlain(argument.toJava()).await())

    /**
     * @see [getBudget].
     * @param budgetName Budget Name.
     * @param scope The scope associated with budget operations. This includes '/subscriptions/{subscriptionId}/' for subscription scope, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for resourceGroup scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}' for Billing Account scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/departments/{departmentId}' for Department scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/enrollmentAccounts/{enrollmentAccountId}' for EnrollmentAccount scope, '/providers/Microsoft.Management/managementGroups/{managementGroupId}' for Management Group scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}' for billingProfile scope, '/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/invoiceSections/{invoiceSectionId}' for invoiceSection scope.
     * @return A budget resource.
     */
    public suspend fun getBudget(budgetName: String, scope: String): GetBudgetResult {
        val argument = GetBudgetPlainArgs(
            budgetName = budgetName,
            scope = scope,
        )
        return toKotlin(getBudgetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBudget].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;consumption&#46;kotlin&#46;inputs&#46;GetBudgetPlainArgs].
     * @return A budget resource.
     */
    public suspend fun getBudget(argument: suspend GetBudgetPlainArgsBuilder.() -> Unit): GetBudgetResult {
        val builder = GetBudgetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getBudgetPlain(builtArgument.toJava()).await())
    }
}
