@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The comparison operator.
 */
public enum class OperatorType(
    public val javaValue: com.pulumi.azurenative.consumption.enums.OperatorType,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.enums.OperatorType> {
    /**
     * Alert will be triggered if the evaluated cost is the same as threshold value. Note: It’s not recommended to use this OperatorType as there’s low chance of cost being exactly the same as threshold value, leading to missing of your alert. This OperatorType will be deprecated in future.
     */
    EqualTo(com.pulumi.azurenative.consumption.enums.OperatorType.EqualTo),

    /**
     * Alert will be triggered if the evaluated cost is greater than the threshold value. Note: This is the recommended OperatorType while configuring Budget Alert.
     */
    GreaterThan(com.pulumi.azurenative.consumption.enums.OperatorType.GreaterThan),

    /**
     * Alert will be triggered if the evaluated cost is greater than or equal to the threshold value.
     */
    GreaterThanOrEqualTo(com.pulumi.azurenative.consumption.enums.OperatorType.GreaterThanOrEqualTo),
    ;

    override fun toJava(): com.pulumi.azurenative.consumption.enums.OperatorType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.enums.OperatorType): OperatorType = OperatorType.values().first { it.javaValue == javaType }
    }
}
