@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.inputs

import com.pulumi.azurenative.consumption.inputs.BudgetTimePeriodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The start and end date for a budget.
 * @property endDate The end date for the budget. If not provided, we default this to 10 years from the start date.
 * @property startDate The start date for the budget.
 */
public data class BudgetTimePeriodArgs(
    public val endDate: Output<String>? = null,
    public val startDate: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.consumption.inputs.BudgetTimePeriodArgs> {
    override fun toJava(): com.pulumi.azurenative.consumption.inputs.BudgetTimePeriodArgs =
        com.pulumi.azurenative.consumption.inputs.BudgetTimePeriodArgs.builder()
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .startDate(startDate.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BudgetTimePeriodArgs].
 */
@PulumiTagMarker
public class BudgetTimePeriodArgsBuilder internal constructor() {
    private var endDate: Output<String>? = null

    private var startDate: Output<String>? = null

    /**
     * @param value The end date for the budget. If not provided, we default this to 10 years from the start date.
     */
    @JvmName("vnyynelefjwjtqoo")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value The start date for the budget.
     */
    @JvmName("tjtsxyculwddbatq")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value The end date for the budget. If not provided, we default this to 10 years from the start date.
     */
    @JvmName("egutjpwlnqewsmcd")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value The start date for the budget.
     */
    @JvmName("sbiqalchfxfksbqh")
    public suspend fun startDate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    internal fun build(): BudgetTimePeriodArgs = BudgetTimePeriodArgs(
        endDate = endDate,
        startDate = startDate ?: throw PulumiNullFieldException("startDate"),
    )
}
