@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The start and end date for a budget.
 * @property endDate The end date for the budget. If not provided, we default this to 10 years from the start date.
 * @property startDate The start date for the budget.
 */
public data class BudgetTimePeriodResponse(
    public val endDate: String? = null,
    public val startDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.outputs.BudgetTimePeriodResponse): BudgetTimePeriodResponse = BudgetTimePeriodResponse(
            endDate = javaType.endDate().map({ args0 -> args0 }).orElse(null),
            startDate = javaType.startDate(),
        )
    }
}
