@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The current amount of cost which is being tracked for a budget.
 * @property amount The total amount of cost which is being tracked by the budget.
 * @property unit The unit of measure for the budget amount.
 */
public data class CurrentSpendResponse(
    public val amount: Double,
    public val unit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.outputs.CurrentSpendResponse): CurrentSpendResponse = CurrentSpendResponse(
            amount = javaType.amount(),
            unit = javaType.unit(),
        )
    }
}
