@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.consumption.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The notification associated with a budget.
 * @property contactEmails Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact email or contact group specified at the Subscription or Resource Group scopes. All other scopes must have at least one contact email specified.
 * @property contactGroups Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified Azure resource id. Only supported at Subscription or Resource Group scopes.
 * @property contactRoles Contact roles to send the budget notification to when the threshold is exceeded.
 * @property enabled The notification is enabled or not.
 * @property locale Language in which the recipient will receive the notification
 * @property operator The comparison operator.
 * @property threshold Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
 * @property thresholdType The type of threshold
 */
public data class NotificationResponse(
    public val contactEmails: List<String>,
    public val contactGroups: List<String>? = null,
    public val contactRoles: List<String>? = null,
    public val enabled: Boolean,
    public val locale: String? = null,
    public val `operator`: String,
    public val threshold: Double,
    public val thresholdType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.consumption.outputs.NotificationResponse): NotificationResponse = NotificationResponse(
            contactEmails = javaType.contactEmails().map({ args0 -> args0 }),
            contactGroups = javaType.contactGroups().map({ args0 -> args0 }),
            contactRoles = javaType.contactRoles().map({ args0 -> args0 }),
            enabled = javaType.enabled(),
            locale = javaType.locale().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`(),
            threshold = javaType.threshold(),
            thresholdType = javaType.thresholdType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
