@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin

import com.pulumi.azurenative.containerinstance.ContainerGroupArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.ContainerGroupPriority
import com.pulumi.azurenative.containerinstance.kotlin.enums.ContainerGroupRestartPolicy
import com.pulumi.azurenative.containerinstance.kotlin.enums.ContainerGroupSku
import com.pulumi.azurenative.containerinstance.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ConfidentialComputePropertiesArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ConfidentialComputePropertiesArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerGroupDiagnosticsArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerGroupDiagnosticsArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerGroupIdentityArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerGroupIdentityArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerGroupSubnetIdArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ContainerGroupSubnetIdArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.DeploymentExtensionSpecArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.DeploymentExtensionSpecArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.DnsConfigurationArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.DnsConfigurationArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.EncryptionPropertiesArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.EncryptionPropertiesArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ImageRegistryCredentialArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.ImageRegistryCredentialArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.InitContainerDefinitionArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.InitContainerDefinitionArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.IpAddressArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.IpAddressArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.inputs.VolumeArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.VolumeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A container group.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2017-08-01-preview, 2017-12-01-preview, 2021-03-01, 2021-07-01, 2023-02-01-preview.
 * ## Example Usage
 * ### ConfidentialContainerGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerGroup = new AzureNative.ContainerInstance.ContainerGroup("containerGroup", new()
 *     {
 *         ConfidentialComputeProperties = new AzureNative.ContainerInstance.Inputs.ConfidentialComputePropertiesArgs
 *         {
 *             CcePolicy = "eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19",
 *         },
 *         ContainerGroupName = "demo1",
 *         Containers = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerArgs
 *             {
 *                 Command = new() { },
 *                 EnvironmentVariables = new() { },
 *                 Image = "confiimage",
 *                 Name = "accdemo",
 *                 Ports = new[]
 *                 {
 *                     new AzureNative.ContainerInstance.Inputs.ContainerPortArgs
 *                     {
 *                         Port = 8000,
 *                     },
 *                 },
 *                 Resources = new AzureNative.ContainerInstance.Inputs.ResourceRequirementsArgs
 *                 {
 *                     Requests = new AzureNative.ContainerInstance.Inputs.ResourceRequestsArgs
 *                     {
 *                         Cpu = 1,
 *                         MemoryInGB = 1.5,
 *                     },
 *                 },
 *                 SecurityContext = new AzureNative.ContainerInstance.Inputs.SecurityContextDefinitionArgs
 *                 {
 *                     Capabilities = new AzureNative.ContainerInstance.Inputs.SecurityContextCapabilitiesDefinitionArgs
 *                     {
 *                         Add = new[]
 *                         {
 *                             "CAP_NET_ADMIN",
 *                         },
 *                     },
 *                     Privileged = false,
 *                 },
 *             },
 *         },
 *         ImageRegistryCredentials = new[] {},
 *         IpAddress = new AzureNative.ContainerInstance.Inputs.IpAddressArgs
 *         {
 *             Ports = new[]
 *             {
 *                 new AzureNative.ContainerInstance.Inputs.PortArgs
 *                 {
 *                     Port = 8000,
 *                     Protocol = AzureNative.ContainerInstance.ContainerGroupNetworkProtocol.TCP,
 *                 },
 *             },
 *             Type = AzureNative.ContainerInstance.ContainerGroupIpAddressType.Public,
 *         },
 *         Location = "westeurope",
 *         OsType = AzureNative.ContainerInstance.OperatingSystemTypes.Linux,
 *         ResourceGroupName = "demo",
 *         Sku = AzureNative.ContainerInstance.ContainerGroupSku.Confidential,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerinstance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerinstance.NewContainerGroup(ctx, "containerGroup", &containerinstance.ContainerGroupArgs{
 * 			ConfidentialComputeProperties: &containerinstance.ConfidentialComputePropertiesArgs{
 * 				CcePolicy: pulumi.String("eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19"),
 * 			},
 * 			ContainerGroupName: pulumi.String("demo1"),
 * 			Containers: containerinstance.ContainerArray{
 * 				&containerinstance.ContainerArgs{
 * 					Command:              pulumi.StringArray{},
 * 					EnvironmentVariables: containerinstance.EnvironmentVariableArray{},
 * 					Image:                pulumi.String("confiimage"),
 * 					Name:                 pulumi.String("accdemo"),
 * 					Ports: containerinstance.ContainerPortArray{
 * 						&containerinstance.ContainerPortArgs{
 * 							Port: pulumi.Int(8000),
 * 						},
 * 					},
 * 					Resources: &containerinstance.ResourceRequirementsArgs{
 * 						Requests: &containerinstance.ResourceRequestsArgs{
 * 							Cpu:        pulumi.Float64(1),
 * 							MemoryInGB: pulumi.Float64(1.5),
 * 						},
 * 					},
 * 					SecurityContext: &containerinstance.SecurityContextDefinitionArgs{
 * 						Capabilities: &containerinstance.SecurityContextCapabilitiesDefinitionArgs{
 * 							Add: pulumi.StringArray{
 * 								pulumi.String("CAP_NET_ADMIN"),
 * 							},
 * 						},
 * 						Privileged: pulumi.Bool(false),
 * 					},
 * 				},
 * 			},
 * 			ImageRegistryCredentials: containerinstance.ImageRegistryCredentialArray{},
 * 			IpAddress: &containerinstance.IpAddressArgs{
 * 				Ports: containerinstance.PortArray{
 * 					&containerinstance.PortArgs{
 * 						Port:     pulumi.Int(8000),
 * 						Protocol: pulumi.String(containerinstance.ContainerGroupNetworkProtocolTCP),
 * 					},
 * 				},
 * 				Type: pulumi.String(containerinstance.ContainerGroupIpAddressTypePublic),
 * 			},
 * 			Location:          pulumi.String("westeurope"),
 * 			OsType:            pulumi.String(containerinstance.OperatingSystemTypesLinux),
 * 			ResourceGroupName: pulumi.String("demo"),
 * 			Sku:               pulumi.String(containerinstance.ContainerGroupSkuConfidential),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerinstance.ContainerGroup;
 * import com.pulumi.azurenative.containerinstance.ContainerGroupArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ConfidentialComputePropertiesArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.SecurityContextDefinitionArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.SecurityContextCapabilitiesDefinitionArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerGroup = new ContainerGroup("containerGroup", ContainerGroupArgs.builder()
 *             .confidentialComputeProperties(ConfidentialComputePropertiesArgs.builder()
 *                 .ccePolicy("eyJhbGxvd19hbGwiOiB0cnVlLCAiY29udGFpbmVycyI6IHsibGVuZ3RoIjogMCwgImVsZW1lbnRzIjogbnVsbH19")
 *                 .build())
 *             .containerGroupName("demo1")
 *             .containers(ContainerArgs.builder()
 *                 .command()
 *                 .environmentVariables()
 *                 .image("confiimage")
 *                 .name("accdemo")
 *                 .ports(ContainerPortArgs.builder()
 *                     .port(8000)
 *                     .build())
 *                 .resources(ResourceRequirementsArgs.builder()
 *                     .requests(ResourceRequestsArgs.builder()
 *                         .cpu(1)
 *                         .memoryInGB(1.5)
 *                         .build())
 *                     .build())
 *                 .securityContext(SecurityContextDefinitionArgs.builder()
 *                     .capabilities(SecurityContextCapabilitiesDefinitionArgs.builder()
 *                         .add("CAP_NET_ADMIN")
 *                         .build())
 *                     .privileged(false)
 *                     .build())
 *                 .build())
 *             .imageRegistryCredentials()
 *             .ipAddress(IpAddressArgs.builder()
 *                 .ports(PortArgs.builder()
 *                     .port(8000)
 *                     .protocol("TCP")
 *                     .build())
 *                 .type("Public")
 *                 .build())
 *             .location("westeurope")
 *             .osType("Linux")
 *             .resourceGroupName("demo")
 *             .sku("Confidential")
 *             .build());
 *     }
 * }
 * ```
 * ### ContainerGroupCreateWithExtensions
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerGroup = new AzureNative.ContainerInstance.ContainerGroup("containerGroup", new()
 *     {
 *         ContainerGroupName = "demo1",
 *         Containers = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerArgs
 *             {
 *                 Command = new() { },
 *                 EnvironmentVariables = new() { },
 *                 Image = "nginx",
 *                 Name = "demo1",
 *                 Ports = new[]
 *                 {
 *                     new AzureNative.ContainerInstance.Inputs.ContainerPortArgs
 *                     {
 *                         Port = 80,
 *                     },
 *                 },
 *                 Resources = new AzureNative.ContainerInstance.Inputs.ResourceRequirementsArgs
 *                 {
 *                     Requests = new AzureNative.ContainerInstance.Inputs.ResourceRequestsArgs
 *                     {
 *                         Cpu = 1,
 *                         MemoryInGB = 1.5,
 *                     },
 *                 },
 *             },
 *         },
 *         Extensions = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.DeploymentExtensionSpecArgs
 *             {
 *                 ExtensionType = "kube-proxy",
 *                 Name = "kube-proxy",
 *                 ProtectedSettings = new Dictionary<string, object?>
 *                 {
 *                     ["kubeConfig"] = "<kubeconfig encoded string>",
 *                 },
 *                 Settings = new Dictionary<string, object?>
 *                 {
 *                     ["clusterCidr"] = "10.240.0.0/16",
 *                     ["kubeVersion"] = "v1.9.10",
 *                 },
 *                 Version = "1.0",
 *             },
 *             new AzureNative.ContainerInstance.Inputs.DeploymentExtensionSpecArgs
 *             {
 *                 ExtensionType = "realtime-metrics",
 *                 Name = "vk-realtime-metrics",
 *                 Version = "1.0",
 *             },
 *         },
 *         ImageRegistryCredentials = new[] {},
 *         IpAddress = new AzureNative.ContainerInstance.Inputs.IpAddressArgs
 *         {
 *             Ports = new[]
 *             {
 *                 new AzureNative.ContainerInstance.Inputs.PortArgs
 *                 {
 *                     Port = 80,
 *                     Protocol = AzureNative.ContainerInstance.ContainerGroupNetworkProtocol.TCP,
 *                 },
 *             },
 *             Type = AzureNative.ContainerInstance.ContainerGroupIpAddressType.Private,
 *         },
 *         Location = "eastus2",
 *         OsType = AzureNative.ContainerInstance.OperatingSystemTypes.Linux,
 *         ResourceGroupName = "demo",
 *         SubnetIds = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerGroupSubnetIdArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerinstance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerinstance.NewContainerGroup(ctx, "containerGroup", &containerinstance.ContainerGroupArgs{
 * 			ContainerGroupName: pulumi.String("demo1"),
 * 			Containers: containerinstance.ContainerArray{
 * 				&containerinstance.ContainerArgs{
 * 					Command:              pulumi.StringArray{},
 * 					EnvironmentVariables: containerinstance.EnvironmentVariableArray{},
 * 					Image:                pulumi.String("nginx"),
 * 					Name:                 pulumi.String("demo1"),
 * 					Ports: containerinstance.ContainerPortArray{
 * 						&containerinstance.ContainerPortArgs{
 * 							Port: pulumi.Int(80),
 * 						},
 * 					},
 * 					Resources: &containerinstance.ResourceRequirementsArgs{
 * 						Requests: &containerinstance.ResourceRequestsArgs{
 * 							Cpu:        pulumi.Float64(1),
 * 							MemoryInGB: pulumi.Float64(1.5),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Extensions: containerinstance.DeploymentExtensionSpecArray{
 * 				&containerinstance.DeploymentExtensionSpecArgs{
 * 					ExtensionType: pulumi.String("kube-proxy"),
 * 					Name:          pulumi.String("kube-proxy"),
 * 					ProtectedSettings: pulumi.Any(map[string]interface{}{
 * 						"kubeConfig": "<kubeconfig encoded string>",
 * 					}),
 * 					Settings: pulumi.Any(map[string]interface{}{
 * 						"clusterCidr": "10.240.0.0/16",
 * 						"kubeVersion": "v1.9.10",
 * 					}),
 * 					Version: pulumi.String("1.0"),
 * 				},
 * 				&containerinstance.DeploymentExtensionSpecArgs{
 * 					ExtensionType: pulumi.String("realtime-metrics"),
 * 					Name:          pulumi.String("vk-realtime-metrics"),
 * 					Version:       pulumi.String("1.0"),
 * 				},
 * 			},
 * 			ImageRegistryCredentials: containerinstance.ImageRegistryCredentialArray{},
 * 			IpAddress: &containerinstance.IpAddressArgs{
 * 				Ports: containerinstance.PortArray{
 * 					&containerinstance.PortArgs{
 * 						Port:     pulumi.Int(80),
 * 						Protocol: pulumi.String(containerinstance.ContainerGroupNetworkProtocolTCP),
 * 					},
 * 				},
 * 				Type: pulumi.String(containerinstance.ContainerGroupIpAddressTypePrivate),
 * 			},
 * 			Location:          pulumi.String("eastus2"),
 * 			OsType:            pulumi.String(containerinstance.OperatingSystemTypesLinux),
 * 			ResourceGroupName: pulumi.String("demo"),
 * 			SubnetIds: containerinstance.ContainerGroupSubnetIdArray{
 * 				&containerinstance.ContainerGroupSubnetIdArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerinstance.ContainerGroup;
 * import com.pulumi.azurenative.containerinstance.ContainerGroupArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.DeploymentExtensionSpecArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.IpAddressArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerGroupSubnetIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerGroup = new ContainerGroup("containerGroup", ContainerGroupArgs.builder()
 *             .containerGroupName("demo1")
 *             .containers(ContainerArgs.builder()
 *                 .command()
 *                 .environmentVariables()
 *                 .image("nginx")
 *                 .name("demo1")
 *                 .ports(ContainerPortArgs.builder()
 *                     .port(80)
 *                     .build())
 *                 .resources(ResourceRequirementsArgs.builder()
 *                     .requests(ResourceRequestsArgs.builder()
 *                         .cpu(1)
 *                         .memoryInGB(1.5)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .extensions(
 *                 DeploymentExtensionSpecArgs.builder()
 *                     .extensionType("kube-proxy")
 *                     .name("kube-proxy")
 *                     .protectedSettings(Map.of("kubeConfig", "<kubeconfig encoded string>"))
 *                     .settings(Map.ofEntries(
 *                         Map.entry("clusterCidr", "10.240.0.0/16"),
 *                         Map.entry("kubeVersion", "v1.9.10")
 *                     ))
 *                     .version("1.0")
 *                     .build(),
 *                 DeploymentExtensionSpecArgs.builder()
 *                     .extensionType("realtime-metrics")
 *                     .name("vk-realtime-metrics")
 *                     .version("1.0")
 *                     .build())
 *             .imageRegistryCredentials()
 *             .ipAddress(IpAddressArgs.builder()
 *                 .ports(PortArgs.builder()
 *                     .port(80)
 *                     .protocol("TCP")
 *                     .build())
 *                 .type("Private")
 *                 .build())
 *             .location("eastus2")
 *             .osType("Linux")
 *             .resourceGroupName("demo")
 *             .subnetIds(ContainerGroupSubnetIdArgs.builder()
 *                 .id("/subscriptions/00000000-0000-0000-0000-00000000/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-rg-vnet/subnets/test-subnet")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### ContainerGroupsCreateWithPriority
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var containerGroup = new AzureNative.ContainerInstance.ContainerGroup("containerGroup", new()
 *     {
 *         ContainerGroupName = "demo1",
 *         Containers = new[]
 *         {
 *             new AzureNative.ContainerInstance.Inputs.ContainerArgs
 *             {
 *                 Command = new[]
 *                 {
 *                     "/bin/sh",
 *                     "-c",
 *                     "sleep 10",
 *                 },
 *                 Image = "alpine:latest",
 *                 Name = "test-container-001",
 *                 Resources = new AzureNative.ContainerInstance.Inputs.ResourceRequirementsArgs
 *                 {
 *                     Requests = new AzureNative.ContainerInstance.Inputs.ResourceRequestsArgs
 *                     {
 *                         Cpu = 1,
 *                         MemoryInGB = 1,
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         OsType = AzureNative.ContainerInstance.OperatingSystemTypes.Linux,
 *         Priority = AzureNative.ContainerInstance.ContainerGroupPriority.Spot,
 *         ResourceGroupName = "demo",
 *         RestartPolicy = AzureNative.ContainerInstance.ContainerGroupRestartPolicy.Never,
 *         Sku = AzureNative.ContainerInstance.ContainerGroupSku.Standard,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerinstance/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerinstance.NewContainerGroup(ctx, "containerGroup", &containerinstance.ContainerGroupArgs{
 * 			ContainerGroupName: pulumi.String("demo1"),
 * 			Containers: containerinstance.ContainerArray{
 * 				&containerinstance.ContainerArgs{
 * 					Command: pulumi.StringArray{
 * 						pulumi.String("/bin/sh"),
 * 						pulumi.String("-c"),
 * 						pulumi.String("sleep 10"),
 * 					},
 * 					Image: pulumi.String("alpine:latest"),
 * 					Name:  pulumi.String("test-container-001"),
 * 					Resources: &containerinstance.ResourceRequirementsArgs{
 * 						Requests: &containerinstance.ResourceRequestsArgs{
 * 							Cpu:        pulumi.Float64(1),
 * 							MemoryInGB: pulumi.Float64(1),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			OsType:            pulumi.String(containerinstance.OperatingSystemTypesLinux),
 * 			Priority:          pulumi.String(containerinstance.ContainerGroupPrioritySpot),
 * 			ResourceGroupName: pulumi.String("demo"),
 * 			RestartPolicy:     pulumi.String(containerinstance.ContainerGroupRestartPolicyNever),
 * 			Sku:               pulumi.String(containerinstance.ContainerGroupSkuStandard),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerinstance.ContainerGroup;
 * import com.pulumi.azurenative.containerinstance.ContainerGroupArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ContainerArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequirementsArgs;
 * import com.pulumi.azurenative.containerinstance.inputs.ResourceRequestsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var containerGroup = new ContainerGroup("containerGroup", ContainerGroupArgs.builder()
 *             .containerGroupName("demo1")
 *             .containers(ContainerArgs.builder()
 *                 .command(
 *                     "/bin/sh",
 *                     "-c",
 *                     "sleep 10")
 *                 .image("alpine:latest")
 *                 .name("test-container-001")
 *                 .resources(ResourceRequirementsArgs.builder()
 *                     .requests(ResourceRequestsArgs.builder()
 *                         .cpu(1)
 *                         .memoryInGB(1)
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("eastus")
 *             .osType("Linux")
 *             .priority("Spot")
 *             .resourceGroupName("demo")
 *             .restartPolicy("Never")
 *             .sku("Standard")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerinstance:ContainerGroup demo1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}
 * ```
 * @property confidentialComputeProperties The properties for confidential container group
 * @property containerGroupName The name of the container group.
 * @property containers The containers within the container group.
 * @property diagnostics The diagnostic information for a container group.
 * @property dnsConfig The DNS config information for a container group.
 * @property encryptionProperties The encryption properties for a container group.
 * @property extensions extensions used by virtual kubelet
 * @property identity The identity of the container group, if configured.
 * @property imageRegistryCredentials The image registry credentials by which the container group is created from.
 * @property initContainers The init containers for a container group.
 * @property ipAddress The IP address type of the container group.
 * @property location The resource location.
 * @property osType The operating system type required by the containers in the container group.
 * @property priority The priority of the container group.
 * @property resourceGroupName The name of the resource group.
 * @property restartPolicy Restart policy for all containers within the container group.
 * - `Always` Always restart
 * - `OnFailure` Restart on failure
 * - `Never` Never restart
 * @property sku The SKU for a container group.
 * @property subnetIds The subnet resource IDs for a container group.
 * @property tags The resource tags.
 * @property volumes The list of volumes that can be mounted by containers in this container group.
 * @property zones The zones for the container group.
 */
public data class ContainerGroupArgs(
    public val confidentialComputeProperties: Output<ConfidentialComputePropertiesArgs>? = null,
    public val containerGroupName: Output<String>? = null,
    public val containers: Output<List<ContainerArgs>>? = null,
    public val diagnostics: Output<ContainerGroupDiagnosticsArgs>? = null,
    public val dnsConfig: Output<DnsConfigurationArgs>? = null,
    public val encryptionProperties: Output<EncryptionPropertiesArgs>? = null,
    public val extensions: Output<List<DeploymentExtensionSpecArgs>>? = null,
    public val identity: Output<ContainerGroupIdentityArgs>? = null,
    public val imageRegistryCredentials: Output<List<ImageRegistryCredentialArgs>>? = null,
    public val initContainers: Output<List<InitContainerDefinitionArgs>>? = null,
    public val ipAddress: Output<IpAddressArgs>? = null,
    public val location: Output<String>? = null,
    public val osType: Output<Either<String, OperatingSystemTypes>>? = null,
    public val priority: Output<Either<String, ContainerGroupPriority>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val restartPolicy: Output<Either<String, ContainerGroupRestartPolicy>>? = null,
    public val sku: Output<Either<String, ContainerGroupSku>>? = null,
    public val subnetIds: Output<List<ContainerGroupSubnetIdArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumes: Output<List<VolumeArgs>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.ContainerGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.ContainerGroupArgs =
        com.pulumi.azurenative.containerinstance.ContainerGroupArgs.builder()
            .confidentialComputeProperties(
                confidentialComputeProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .containerGroupName(containerGroupName?.applyValue({ args0 -> args0 }))
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .diagnostics(diagnostics?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dnsConfig(dnsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encryptionProperties(
                encryptionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageRegistryCredentials(
                imageRegistryCredentials?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .initContainers(
                initContainers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipAddress(ipAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .priority(
                priority?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .restartPolicy(
                restartPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sku(
                sku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnetIds(
                subnetIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumes(
                volumes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ContainerGroupArgs].
 */
@PulumiTagMarker
public class ContainerGroupArgsBuilder internal constructor() {
    private var confidentialComputeProperties: Output<ConfidentialComputePropertiesArgs>? = null

    private var containerGroupName: Output<String>? = null

    private var containers: Output<List<ContainerArgs>>? = null

    private var diagnostics: Output<ContainerGroupDiagnosticsArgs>? = null

    private var dnsConfig: Output<DnsConfigurationArgs>? = null

    private var encryptionProperties: Output<EncryptionPropertiesArgs>? = null

    private var extensions: Output<List<DeploymentExtensionSpecArgs>>? = null

    private var identity: Output<ContainerGroupIdentityArgs>? = null

    private var imageRegistryCredentials: Output<List<ImageRegistryCredentialArgs>>? = null

    private var initContainers: Output<List<InitContainerDefinitionArgs>>? = null

    private var ipAddress: Output<IpAddressArgs>? = null

    private var location: Output<String>? = null

    private var osType: Output<Either<String, OperatingSystemTypes>>? = null

    private var priority: Output<Either<String, ContainerGroupPriority>>? = null

    private var resourceGroupName: Output<String>? = null

    private var restartPolicy: Output<Either<String, ContainerGroupRestartPolicy>>? = null

    private var sku: Output<Either<String, ContainerGroupSku>>? = null

    private var subnetIds: Output<List<ContainerGroupSubnetIdArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumes: Output<List<VolumeArgs>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The properties for confidential container group
     */
    @JvmName("vtgtvylydnkxkoyf")
    public suspend fun confidentialComputeProperties(`value`: Output<ConfidentialComputePropertiesArgs>) {
        this.confidentialComputeProperties = value
    }

    /**
     * @param value The name of the container group.
     */
    @JvmName("bvofdaasmmpuhdrq")
    public suspend fun containerGroupName(`value`: Output<String>) {
        this.containerGroupName = value
    }

    /**
     * @param value The containers within the container group.
     */
    @JvmName("qfchushsprdevtmg")
    public suspend fun containers(`value`: Output<List<ContainerArgs>>) {
        this.containers = value
    }

    @JvmName("qbcbdpkfbcwxpuvu")
    public suspend fun containers(vararg values: Output<ContainerArgs>) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values The containers within the container group.
     */
    @JvmName("emmsyamfuubxldux")
    public suspend fun containers(values: List<Output<ContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value The diagnostic information for a container group.
     */
    @JvmName("smfgmxnoanmenydn")
    public suspend fun diagnostics(`value`: Output<ContainerGroupDiagnosticsArgs>) {
        this.diagnostics = value
    }

    /**
     * @param value The DNS config information for a container group.
     */
    @JvmName("doignridvfluwfhm")
    public suspend fun dnsConfig(`value`: Output<DnsConfigurationArgs>) {
        this.dnsConfig = value
    }

    /**
     * @param value The encryption properties for a container group.
     */
    @JvmName("mbfxjgnokaopykrt")
    public suspend fun encryptionProperties(`value`: Output<EncryptionPropertiesArgs>) {
        this.encryptionProperties = value
    }

    /**
     * @param value extensions used by virtual kubelet
     */
    @JvmName("bqivkjudqqveagyw")
    public suspend fun extensions(`value`: Output<List<DeploymentExtensionSpecArgs>>) {
        this.extensions = value
    }

    @JvmName("ohkwekrjpqbxmedh")
    public suspend fun extensions(vararg values: Output<DeploymentExtensionSpecArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values extensions used by virtual kubelet
     */
    @JvmName("sxpkyqjxynimultq")
    public suspend fun extensions(values: List<Output<DeploymentExtensionSpecArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value The identity of the container group, if configured.
     */
    @JvmName("qiegbdnxinvqphpi")
    public suspend fun identity(`value`: Output<ContainerGroupIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The image registry credentials by which the container group is created from.
     */
    @JvmName("gtpfnvqyfmlhjlbt")
    public suspend fun imageRegistryCredentials(`value`: Output<List<ImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = value
    }

    @JvmName("cguekqysvhgquycu")
    public suspend fun imageRegistryCredentials(vararg values: Output<ImageRegistryCredentialArgs>) {
        this.imageRegistryCredentials = Output.all(values.asList())
    }

    /**
     * @param values The image registry credentials by which the container group is created from.
     */
    @JvmName("eaqjigycbpicrytu")
    public suspend fun imageRegistryCredentials(values: List<Output<ImageRegistryCredentialArgs>>) {
        this.imageRegistryCredentials = Output.all(values)
    }

    /**
     * @param value The init containers for a container group.
     */
    @JvmName("ewghkrmitxfysanw")
    public suspend fun initContainers(`value`: Output<List<InitContainerDefinitionArgs>>) {
        this.initContainers = value
    }

    @JvmName("qmgqfmxwxcfbeaov")
    public suspend fun initContainers(vararg values: Output<InitContainerDefinitionArgs>) {
        this.initContainers = Output.all(values.asList())
    }

    /**
     * @param values The init containers for a container group.
     */
    @JvmName("olpaexymxlpindht")
    public suspend fun initContainers(values: List<Output<InitContainerDefinitionArgs>>) {
        this.initContainers = Output.all(values)
    }

    /**
     * @param value The IP address type of the container group.
     */
    @JvmName("skjfxolkawhptmpo")
    public suspend fun ipAddress(`value`: Output<IpAddressArgs>) {
        this.ipAddress = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("iicnhmnyblfnppkq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The operating system type required by the containers in the container group.
     */
    @JvmName("xbmmeqpddpggpnhk")
    public suspend fun osType(`value`: Output<Either<String, OperatingSystemTypes>>) {
        this.osType = value
    }

    /**
     * @param value The priority of the container group.
     */
    @JvmName("chuhdurtrwargdnm")
    public suspend fun priority(`value`: Output<Either<String, ContainerGroupPriority>>) {
        this.priority = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hpwknubnurtgprye")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart
     */
    @JvmName("ttcrxksholojxwtx")
    public suspend fun restartPolicy(`value`: Output<Either<String, ContainerGroupRestartPolicy>>) {
        this.restartPolicy = value
    }

    /**
     * @param value The SKU for a container group.
     */
    @JvmName("hacydyuuctjrxlkb")
    public suspend fun sku(`value`: Output<Either<String, ContainerGroupSku>>) {
        this.sku = value
    }

    /**
     * @param value The subnet resource IDs for a container group.
     */
    @JvmName("rstfoodgiyrbpsmd")
    public suspend fun subnetIds(`value`: Output<List<ContainerGroupSubnetIdArgs>>) {
        this.subnetIds = value
    }

    @JvmName("rmhhegdafhgkcqex")
    public suspend fun subnetIds(vararg values: Output<ContainerGroupSubnetIdArgs>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The subnet resource IDs for a container group.
     */
    @JvmName("kisrougavkeaysov")
    public suspend fun subnetIds(values: List<Output<ContainerGroupSubnetIdArgs>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("iuexmpwwcufatfuq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of volumes that can be mounted by containers in this container group.
     */
    @JvmName("rwlntjkkerhfupgd")
    public suspend fun volumes(`value`: Output<List<VolumeArgs>>) {
        this.volumes = value
    }

    @JvmName("edjgbmcubbcrgtib")
    public suspend fun volumes(vararg values: Output<VolumeArgs>) {
        this.volumes = Output.all(values.asList())
    }

    /**
     * @param values The list of volumes that can be mounted by containers in this container group.
     */
    @JvmName("usxuotqpowlcatit")
    public suspend fun volumes(values: List<Output<VolumeArgs>>) {
        this.volumes = Output.all(values)
    }

    /**
     * @param value The zones for the container group.
     */
    @JvmName("ghbllxluystcoctv")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("yoggwenmbtnpdhrw")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values The zones for the container group.
     */
    @JvmName("lkphixwnacayuwru")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The properties for confidential container group
     */
    @JvmName("hpdoiuawqkopwwkp")
    public suspend fun confidentialComputeProperties(`value`: ConfidentialComputePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialComputeProperties = mapped
    }

    /**
     * @param argument The properties for confidential container group
     */
    @JvmName("ndotgfhxmngwxgev")
    public suspend fun confidentialComputeProperties(argument: suspend ConfidentialComputePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ConfidentialComputePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.confidentialComputeProperties = mapped
    }

    /**
     * @param value The name of the container group.
     */
    @JvmName("jhxcaabnvbuocuph")
    public suspend fun containerGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerGroupName = mapped
    }

    /**
     * @param value The containers within the container group.
     */
    @JvmName("fwilnljlggbawhhc")
    public suspend fun containers(`value`: List<ContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument The containers within the container group.
     */
    @JvmName("xbgxlvggvqdbuooq")
    public suspend fun containers(argument: List<suspend ContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument The containers within the container group.
     */
    @JvmName("lcyymitcmfjwomxl")
    public suspend fun containers(vararg argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ContainerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument The containers within the container group.
     */
    @JvmName("mkxqayqlhbateijq")
    public suspend fun containers(argument: suspend ContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values The containers within the container group.
     */
    @JvmName("jcutuobsmtsogvre")
    public suspend fun containers(vararg values: ContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value The diagnostic information for a container group.
     */
    @JvmName("mduxfegvxuexiats")
    public suspend fun diagnostics(`value`: ContainerGroupDiagnosticsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnostics = mapped
    }

    /**
     * @param argument The diagnostic information for a container group.
     */
    @JvmName("ktxatwjwydmkrmcr")
    public suspend fun diagnostics(argument: suspend ContainerGroupDiagnosticsArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerGroupDiagnosticsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diagnostics = mapped
    }

    /**
     * @param value The DNS config information for a container group.
     */
    @JvmName("gpmdgqjuejdbkrrv")
    public suspend fun dnsConfig(`value`: DnsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsConfig = mapped
    }

    /**
     * @param argument The DNS config information for a container group.
     */
    @JvmName("gggcssnwswvhapsg")
    public suspend fun dnsConfig(argument: suspend DnsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DnsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsConfig = mapped
    }

    /**
     * @param value The encryption properties for a container group.
     */
    @JvmName("wugjydyiqhjlqwwa")
    public suspend fun encryptionProperties(`value`: EncryptionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionProperties = mapped
    }

    /**
     * @param argument The encryption properties for a container group.
     */
    @JvmName("pyooypjwyuaopsnl")
    public suspend fun encryptionProperties(argument: suspend EncryptionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionProperties = mapped
    }

    /**
     * @param value extensions used by virtual kubelet
     */
    @JvmName("hixsjpovnbdrqpfo")
    public suspend fun extensions(`value`: List<DeploymentExtensionSpecArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument extensions used by virtual kubelet
     */
    @JvmName("cbgvrsgajdbkajgg")
    public suspend fun extensions(argument: List<suspend DeploymentExtensionSpecArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DeploymentExtensionSpecArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument extensions used by virtual kubelet
     */
    @JvmName("yirohohiphdjbjqr")
    public suspend fun extensions(vararg argument: suspend DeploymentExtensionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DeploymentExtensionSpecArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument extensions used by virtual kubelet
     */
    @JvmName("vbwyrygdjvcmyqcd")
    public suspend fun extensions(argument: suspend DeploymentExtensionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DeploymentExtensionSpecArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values extensions used by virtual kubelet
     */
    @JvmName("ueolqensvknnophi")
    public suspend fun extensions(vararg values: DeploymentExtensionSpecArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value The identity of the container group, if configured.
     */
    @JvmName("geaihtesjlhdvybp")
    public suspend fun identity(`value`: ContainerGroupIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the container group, if configured.
     */
    @JvmName("alrvpqhhmjeseqxs")
    public suspend fun identity(argument: suspend ContainerGroupIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerGroupIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The image registry credentials by which the container group is created from.
     */
    @JvmName("tecgtfhpaqefqrqi")
    public suspend fun imageRegistryCredentials(`value`: List<ImageRegistryCredentialArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credentials by which the container group is created from.
     */
    @JvmName("snwiexyhoixlhais")
    public suspend fun imageRegistryCredentials(argument: List<suspend ImageRegistryCredentialArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageRegistryCredentialArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credentials by which the container group is created from.
     */
    @JvmName("nmcfcjbpdicnnkhg")
    public suspend fun imageRegistryCredentials(vararg argument: suspend ImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageRegistryCredentialArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param argument The image registry credentials by which the container group is created from.
     */
    @JvmName("heawtrjnjbkgpxch")
    public suspend fun imageRegistryCredentials(argument: suspend ImageRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImageRegistryCredentialArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param values The image registry credentials by which the container group is created from.
     */
    @JvmName("fifmimeoextdfcgh")
    public suspend fun imageRegistryCredentials(vararg values: ImageRegistryCredentialArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.imageRegistryCredentials = mapped
    }

    /**
     * @param value The init containers for a container group.
     */
    @JvmName("qwacsxecflqsquel")
    public suspend fun initContainers(`value`: List<InitContainerDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param argument The init containers for a container group.
     */
    @JvmName("qbmtqvblstvoergv")
    public suspend fun initContainers(argument: List<suspend InitContainerDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InitContainerDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument The init containers for a container group.
     */
    @JvmName("jetrjqjblfogrxmi")
    public suspend fun initContainers(vararg argument: suspend InitContainerDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InitContainerDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param argument The init containers for a container group.
     */
    @JvmName("dgtsrwhfllukfarp")
    public suspend fun initContainers(argument: suspend InitContainerDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InitContainerDefinitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.initContainers = mapped
    }

    /**
     * @param values The init containers for a container group.
     */
    @JvmName("sihpxbuymgblgqov")
    public suspend fun initContainers(vararg values: InitContainerDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initContainers = mapped
    }

    /**
     * @param value The IP address type of the container group.
     */
    @JvmName("gkreoqpyqedcxvys")
    public suspend fun ipAddress(`value`: IpAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddress = mapped
    }

    /**
     * @param argument The IP address type of the container group.
     */
    @JvmName("cowciefjskohabli")
    public suspend fun ipAddress(argument: suspend IpAddressArgsBuilder.() -> Unit) {
        val toBeMapped = IpAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ipAddress = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("oaviljwbdplslktw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The operating system type required by the containers in the container group.
     */
    @JvmName("apursnoyuonnuvlc")
    public suspend fun osType(`value`: Either<String, OperatingSystemTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operating system type required by the containers in the container group.
     */
    @JvmName("jmsgnxrhdgrcqrbb")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatingSystemTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operating system type required by the containers in the container group.
     */
    @JvmName("hfxlpcioooehwijq")
    public fun osType(`value`: OperatingSystemTypes) {
        val toBeMapped = Either.ofRight<String, OperatingSystemTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The priority of the container group.
     */
    @JvmName("ypwmpomiqldwteuk")
    public suspend fun priority(`value`: Either<String, ContainerGroupPriority>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The priority of the container group.
     */
    @JvmName("wkwrujgxbkyeabfm")
    public fun priority(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerGroupPriority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The priority of the container group.
     */
    @JvmName("jeidpeysgsjspxei")
    public fun priority(`value`: ContainerGroupPriority) {
        val toBeMapped = Either.ofRight<String, ContainerGroupPriority>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("utgsyfwdtbcotuwt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart
     */
    @JvmName("rlagdhxpblxfjbul")
    public suspend fun restartPolicy(`value`: Either<String, ContainerGroupRestartPolicy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restartPolicy = mapped
    }

    /**
     * @param value Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart
     */
    @JvmName("vkalkiglwtqfxjvs")
    public fun restartPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerGroupRestartPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restartPolicy = mapped
    }

    /**
     * @param value Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart
     */
    @JvmName("djavdxpfifrgtook")
    public fun restartPolicy(`value`: ContainerGroupRestartPolicy) {
        val toBeMapped = Either.ofRight<String, ContainerGroupRestartPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restartPolicy = mapped
    }

    /**
     * @param value The SKU for a container group.
     */
    @JvmName("maalnuysbcuojgre")
    public suspend fun sku(`value`: Either<String, ContainerGroupSku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The SKU for a container group.
     */
    @JvmName("djgxiobdxgirbxle")
    public fun sku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ContainerGroupSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The SKU for a container group.
     */
    @JvmName("lcdpxbahlooglrqp")
    public fun sku(`value`: ContainerGroupSku) {
        val toBeMapped = Either.ofRight<String, ContainerGroupSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value The subnet resource IDs for a container group.
     */
    @JvmName("ljibpjtnoqiflkyx")
    public suspend fun subnetIds(`value`: List<ContainerGroupSubnetIdArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param argument The subnet resource IDs for a container group.
     */
    @JvmName("btxnuswqoggkfvkw")
    public suspend fun subnetIds(argument: List<suspend ContainerGroupSubnetIdArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerGroupSubnetIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetIds = mapped
    }

    /**
     * @param argument The subnet resource IDs for a container group.
     */
    @JvmName("ttnabixmyxprgbjm")
    public suspend fun subnetIds(vararg argument: suspend ContainerGroupSubnetIdArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerGroupSubnetIdArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.subnetIds = mapped
    }

    /**
     * @param argument The subnet resource IDs for a container group.
     */
    @JvmName("spggmmqoedmadcjq")
    public suspend fun subnetIds(argument: suspend ContainerGroupSubnetIdArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ContainerGroupSubnetIdArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subnetIds = mapped
    }

    /**
     * @param values The subnet resource IDs for a container group.
     */
    @JvmName("pcnvypqcgrkqsckd")
    public suspend fun subnetIds(vararg values: ContainerGroupSubnetIdArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("ptxatfxcycktclpq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("awcjrbawtmnhawec")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The list of volumes that can be mounted by containers in this container group.
     */
    @JvmName("ttscwmfmeshwsvyo")
    public suspend fun volumes(`value`: List<VolumeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes that can be mounted by containers in this container group.
     */
    @JvmName("ddtdankcomanifyg")
    public suspend fun volumes(argument: List<suspend VolumeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { VolumeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes that can be mounted by containers in this container group.
     */
    @JvmName("oyeriuxdiwjmgdsn")
    public suspend fun volumes(vararg argument: suspend VolumeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { VolumeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param argument The list of volumes that can be mounted by containers in this container group.
     */
    @JvmName("ufllgqbsooyhvqsh")
    public suspend fun volumes(argument: suspend VolumeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VolumeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.volumes = mapped
    }

    /**
     * @param values The list of volumes that can be mounted by containers in this container group.
     */
    @JvmName("pbdkmcaqycqobret")
    public suspend fun volumes(vararg values: VolumeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumes = mapped
    }

    /**
     * @param value The zones for the container group.
     */
    @JvmName("ontyumehttplkedi")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values The zones for the container group.
     */
    @JvmName("rhakoheghdubhkmf")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): ContainerGroupArgs = ContainerGroupArgs(
        confidentialComputeProperties = confidentialComputeProperties,
        containerGroupName = containerGroupName,
        containers = containers,
        diagnostics = diagnostics,
        dnsConfig = dnsConfig,
        encryptionProperties = encryptionProperties,
        extensions = extensions,
        identity = identity,
        imageRegistryCredentials = imageRegistryCredentials,
        initContainers = initContainers,
        ipAddress = ipAddress,
        location = location,
        osType = osType,
        priority = priority,
        resourceGroupName = resourceGroupName,
        restartPolicy = restartPolicy,
        sku = sku,
        subnetIds = subnetIds,
        tags = tags,
        volumes = volumes,
        zones = zones,
    )
}
