@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin

import com.pulumi.azurenative.containerinstance.ContainerinstanceFunctions.getContainerGroupPlain
import com.pulumi.azurenative.containerinstance.kotlin.inputs.GetContainerGroupPlainArgs
import com.pulumi.azurenative.containerinstance.kotlin.inputs.GetContainerGroupPlainArgsBuilder
import com.pulumi.azurenative.containerinstance.kotlin.outputs.GetContainerGroupResult
import com.pulumi.azurenative.containerinstance.kotlin.outputs.GetContainerGroupResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ContainerinstanceFunctions {
    /**
     * Gets the properties of the specified container group in the specified subscription and resource group. The operation returns the properties of each container group including containers, image registry credentials, restart policy, IP address type, OS type, state, and volumes.
     * Azure REST API version: 2023-05-01.
     * Other available API versions: 2017-08-01-preview, 2017-12-01-preview, 2021-03-01, 2021-07-01, 2023-02-01-preview.
     * @param argument null
     * @return A container group.
     */
    public suspend fun getContainerGroup(argument: GetContainerGroupPlainArgs): GetContainerGroupResult = toKotlin(getContainerGroupPlain(argument.toJava()).await())

    /**
     * @see [getContainerGroup].
     * @param containerGroupName The name of the container group.
     * @param resourceGroupName The name of the resource group.
     * @return A container group.
     */
    public suspend fun getContainerGroup(containerGroupName: String, resourceGroupName: String): GetContainerGroupResult {
        val argument = GetContainerGroupPlainArgs(
            containerGroupName = containerGroupName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getContainerGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getContainerGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerinstance&#46;kotlin&#46;inputs&#46;GetContainerGroupPlainArgs].
     * @return A container group.
     */
    public suspend fun getContainerGroup(argument: suspend GetContainerGroupPlainArgsBuilder.() -> Unit): GetContainerGroupResult {
        val builder = GetContainerGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getContainerGroupPlain(builtArgument.toJava()).await())
    }
}
