@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Restart policy for all containers within the container group.
 * - `Always` Always restart
 * - `OnFailure` Restart on failure
 * - `Never` Never restart
 */
public enum class ContainerGroupRestartPolicy(
    public val javaValue: com.pulumi.azurenative.containerinstance.enums.ContainerGroupRestartPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.enums.ContainerGroupRestartPolicy> {
    Always(com.pulumi.azurenative.containerinstance.enums.ContainerGroupRestartPolicy.Always),
    OnFailure(com.pulumi.azurenative.containerinstance.enums.ContainerGroupRestartPolicy.OnFailure),
    Never(com.pulumi.azurenative.containerinstance.enums.ContainerGroupRestartPolicy.Never),
    ;

    override fun toJava(): com.pulumi.azurenative.containerinstance.enums.ContainerGroupRestartPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.enums.ContainerGroupRestartPolicy): ContainerGroupRestartPolicy =
            ContainerGroupRestartPolicy.values().first { it.javaValue == javaType }
    }
}
