@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the container group. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the container group.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType> {
    SystemAssigned(com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType.SystemAssigned_UserAssigned),
    None(com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType.None),
    ;

    override fun toJava(): com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.enums.ResourceIdentityType): ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
