@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerExecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The container execution command, for liveness or readiness probe
 * @property command The commands to execute within the container.
 */
public data class ContainerExecArgs(
    public val command: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerExecArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerExecArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerExecArgs.builder()
            .command(command?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ContainerExecArgs].
 */
@PulumiTagMarker
public class ContainerExecArgsBuilder internal constructor() {
    private var command: Output<List<String>>? = null

    /**
     * @param value The commands to execute within the container.
     */
    @JvmName("nehkuxtieaddwtfg")
    public suspend fun command(`value`: Output<List<String>>) {
        this.command = value
    }

    @JvmName("wigoeaurdxcqghud")
    public suspend fun command(vararg values: Output<String>) {
        this.command = Output.all(values.asList())
    }

    /**
     * @param values The commands to execute within the container.
     */
    @JvmName("fdnoegybeglsalrm")
    public suspend fun command(values: List<Output<String>>) {
        this.command = Output.all(values)
    }

    /**
     * @param value The commands to execute within the container.
     */
    @JvmName("buregmhqwrfktddg")
    public suspend fun command(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param values The commands to execute within the container.
     */
    @JvmName("etgjsuwobcjjmnek")
    public suspend fun command(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    internal fun build(): ContainerExecArgs = ContainerExecArgs(
        command = command,
    )
}
