@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ContainerProbeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The container probe, for liveness or readiness
 * @property exec The execution command to probe
 * @property failureThreshold The failure threshold.
 * @property httpGet The Http Get settings to probe
 * @property initialDelaySeconds The initial delay seconds.
 * @property periodSeconds The period seconds.
 * @property successThreshold The success threshold.
 * @property timeoutSeconds The timeout seconds.
 */
public data class ContainerProbeArgs(
    public val exec: Output<ContainerExecArgs>? = null,
    public val failureThreshold: Output<Int>? = null,
    public val httpGet: Output<ContainerHttpGetArgs>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val successThreshold: Output<Int>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ContainerProbeArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ContainerProbeArgs =
        com.pulumi.azurenative.containerinstance.inputs.ContainerProbeArgs.builder()
            .exec(exec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .httpGet(httpGet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerProbeArgs].
 */
@PulumiTagMarker
public class ContainerProbeArgsBuilder internal constructor() {
    private var exec: Output<ContainerExecArgs>? = null

    private var failureThreshold: Output<Int>? = null

    private var httpGet: Output<ContainerHttpGetArgs>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var successThreshold: Output<Int>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value The execution command to probe
     */
    @JvmName("ctoiwapnkmmldrhs")
    public suspend fun exec(`value`: Output<ContainerExecArgs>) {
        this.exec = value
    }

    /**
     * @param value The failure threshold.
     */
    @JvmName("gtotqdqwlqsxpvsw")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value The Http Get settings to probe
     */
    @JvmName("oavwpmmwvwnsyguk")
    public suspend fun httpGet(`value`: Output<ContainerHttpGetArgs>) {
        this.httpGet = value
    }

    /**
     * @param value The initial delay seconds.
     */
    @JvmName("hpbhwdelmhxqfhmx")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value The period seconds.
     */
    @JvmName("gknohbpvtechjtbf")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value The success threshold.
     */
    @JvmName("yfiytsufuypfxubj")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value The timeout seconds.
     */
    @JvmName("vrbmwhhfvjloythv")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value The execution command to probe
     */
    @JvmName("askdkentneeactlb")
    public suspend fun exec(`value`: ContainerExecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exec = mapped
    }

    /**
     * @param argument The execution command to probe
     */
    @JvmName("ttlvryidebxmhykx")
    public suspend fun exec(argument: suspend ContainerExecArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerExecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exec = mapped
    }

    /**
     * @param value The failure threshold.
     */
    @JvmName("ihxsrilebfmwwklm")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value The Http Get settings to probe
     */
    @JvmName("olbdohuhmywjfsuq")
    public suspend fun httpGet(`value`: ContainerHttpGetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGet = mapped
    }

    /**
     * @param argument The Http Get settings to probe
     */
    @JvmName("wgnhiqysmigmupsc")
    public suspend fun httpGet(argument: suspend ContainerHttpGetArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerHttpGetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpGet = mapped
    }

    /**
     * @param value The initial delay seconds.
     */
    @JvmName("oqhwpywtqxkxgiqd")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value The period seconds.
     */
    @JvmName("qkgmcmdthqkkfxmn")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value The success threshold.
     */
    @JvmName("iuovqxlkddhvalst")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value The timeout seconds.
     */
    @JvmName("nuiwhsfnigvawetf")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): ContainerProbeArgs = ContainerProbeArgs(
        exec = exec,
        failureThreshold = failureThreshold,
        httpGet = httpGet,
        initialDelaySeconds = initialDelaySeconds,
        periodSeconds = periodSeconds,
        successThreshold = successThreshold,
        timeoutSeconds = timeoutSeconds,
    )
}
