@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.GitRepoVolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a volume that is populated with the contents of a git repository
 * @property directory Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
 * @property repository Repository URL
 * @property revision Commit hash for the specified revision.
 */
public data class GitRepoVolumeArgs(
    public val directory: Output<String>? = null,
    public val repository: Output<String>,
    public val revision: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.GitRepoVolumeArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.GitRepoVolumeArgs =
        com.pulumi.azurenative.containerinstance.inputs.GitRepoVolumeArgs.builder()
            .directory(directory?.applyValue({ args0 -> args0 }))
            .repository(repository.applyValue({ args0 -> args0 }))
            .revision(revision?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitRepoVolumeArgs].
 */
@PulumiTagMarker
public class GitRepoVolumeArgsBuilder internal constructor() {
    private var directory: Output<String>? = null

    private var repository: Output<String>? = null

    private var revision: Output<String>? = null

    /**
     * @param value Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
     */
    @JvmName("vlndwtiqgjpmloqw")
    public suspend fun directory(`value`: Output<String>) {
        this.directory = value
    }

    /**
     * @param value Repository URL
     */
    @JvmName("iksumlgjgtceofwt")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value Commit hash for the specified revision.
     */
    @JvmName("puioalhquqjmfeed")
    public suspend fun revision(`value`: Output<String>) {
        this.revision = value
    }

    /**
     * @param value Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
     */
    @JvmName("vedsbrpdyhmcmicd")
    public suspend fun directory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directory = mapped
    }

    /**
     * @param value Repository URL
     */
    @JvmName("xnpqpohqefwxoytr")
    public suspend fun repository(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param value Commit hash for the specified revision.
     */
    @JvmName("tlcxltvwlasbitmt")
    public suspend fun revision(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revision = mapped
    }

    internal fun build(): GitRepoVolumeArgs = GitRepoVolumeArgs(
        directory = directory,
        repository = repository ?: throw PulumiNullFieldException("repository"),
        revision = revision,
    )
}
