@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.ImageRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Image registry credential.
 * @property identity The identity for the private registry.
 * @property identityUrl The identity URL for the private registry.
 * @property password The password for the private registry.
 * @property server The Docker image registry server without a protocol such as "http" and "https".
 * @property username The username for the private registry.
 */
public data class ImageRegistryCredentialArgs(
    public val identity: Output<String>? = null,
    public val identityUrl: Output<String>? = null,
    public val password: Output<String>? = null,
    public val server: Output<String>,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.ImageRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.ImageRegistryCredentialArgs = com.pulumi.azurenative.containerinstance.inputs.ImageRegistryCredentialArgs.builder()
        .identity(identity?.applyValue({ args0 -> args0 }))
        .identityUrl(identityUrl?.applyValue({ args0 -> args0 }))
        .password(password?.applyValue({ args0 -> args0 }))
        .server(server.applyValue({ args0 -> args0 }))
        .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRegistryCredentialArgs].
 */
@PulumiTagMarker
public class ImageRegistryCredentialArgsBuilder internal constructor() {
    private var identity: Output<String>? = null

    private var identityUrl: Output<String>? = null

    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The identity for the private registry.
     */
    @JvmName("lnogltpgimalcumv")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value The identity URL for the private registry.
     */
    @JvmName("scnopffmqltjkiyb")
    public suspend fun identityUrl(`value`: Output<String>) {
        this.identityUrl = value
    }

    /**
     * @param value The password for the private registry.
     */
    @JvmName("qmpbmunowjolohte")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The Docker image registry server without a protocol such as "http" and "https".
     */
    @JvmName("rmonmoyiqfjnjfeh")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The username for the private registry.
     */
    @JvmName("oqiehkrnbaeloyxj")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The identity for the private registry.
     */
    @JvmName("sqornrmqcveckefq")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value The identity URL for the private registry.
     */
    @JvmName("ffwvksmsewbnysxy")
    public suspend fun identityUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityUrl = mapped
    }

    /**
     * @param value The password for the private registry.
     */
    @JvmName("lbblisxmcjaxkinl")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The Docker image registry server without a protocol such as "http" and "https".
     */
    @JvmName("occaqgtfqqisopkc")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The username for the private registry.
     */
    @JvmName("deajesrxadpslupv")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ImageRegistryCredentialArgs = ImageRegistryCredentialArgs(
        identity = identity,
        identityUrl = identityUrl,
        password = password,
        server = server ?: throw PulumiNullFieldException("server"),
        username = username,
    )
}
