@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.LogAnalyticsArgs.builder
import com.pulumi.azurenative.containerinstance.kotlin.enums.LogAnalyticsLogType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Container group log analytics information.
 * @property logType The log type to be used.
 * @property metadata Metadata for log analytics.
 * @property workspaceId The workspace id for log analytics
 * @property workspaceKey The workspace key for log analytics
 * @property workspaceResourceId The workspace resource id for log analytics
 */
public data class LogAnalyticsArgs(
    public val logType: Output<Either<String, LogAnalyticsLogType>>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val workspaceId: Output<String>,
    public val workspaceKey: Output<String>,
    public val workspaceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.LogAnalyticsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.LogAnalyticsArgs =
        com.pulumi.azurenative.containerinstance.inputs.LogAnalyticsArgs.builder()
            .logType(
                logType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .workspaceId(workspaceId.applyValue({ args0 -> args0 }))
            .workspaceKey(workspaceKey.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogAnalyticsArgs].
 */
@PulumiTagMarker
public class LogAnalyticsArgsBuilder internal constructor() {
    private var logType: Output<Either<String, LogAnalyticsLogType>>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var workspaceId: Output<String>? = null

    private var workspaceKey: Output<String>? = null

    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value The log type to be used.
     */
    @JvmName("vvjbifuvvgfjtdbm")
    public suspend fun logType(`value`: Output<Either<String, LogAnalyticsLogType>>) {
        this.logType = value
    }

    /**
     * @param value Metadata for log analytics.
     */
    @JvmName("mvlrxjfpqrqckceb")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The workspace id for log analytics
     */
    @JvmName("uorytdpqcakdvkhy")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The workspace key for log analytics
     */
    @JvmName("eagvkhtbhouskkcg")
    public suspend fun workspaceKey(`value`: Output<String>) {
        this.workspaceKey = value
    }

    /**
     * @param value The workspace resource id for log analytics
     */
    @JvmName("oexsxjxouqojkshs")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value The log type to be used.
     */
    @JvmName("glxhkkvdnetskbjo")
    public suspend fun logType(`value`: Either<String, LogAnalyticsLogType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logType = mapped
    }

    /**
     * @param value The log type to be used.
     */
    @JvmName("xoexdiuedpvbohwx")
    public fun logType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LogAnalyticsLogType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logType = mapped
    }

    /**
     * @param value The log type to be used.
     */
    @JvmName("scjasehybwniptnh")
    public fun logType(`value`: LogAnalyticsLogType) {
        val toBeMapped = Either.ofRight<String, LogAnalyticsLogType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logType = mapped
    }

    /**
     * @param value Metadata for log analytics.
     */
    @JvmName("lkiayugmhxmcwabl")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Metadata for log analytics.
     */
    @JvmName("ionlmkihcedpgugd")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The workspace id for log analytics
     */
    @JvmName("oydsbvncqvcbkggr")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    /**
     * @param value The workspace key for log analytics
     */
    @JvmName("ggiregnwgvvbgbkf")
    public suspend fun workspaceKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceKey = mapped
    }

    /**
     * @param value The workspace resource id for log analytics
     */
    @JvmName("cltlkxsvnjjelurw")
    public suspend fun workspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): LogAnalyticsArgs = LogAnalyticsArgs(
        logType = logType,
        metadata = metadata,
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
        workspaceKey = workspaceKey ?: throw PulumiNullFieldException("workspaceKey"),
        workspaceResourceId = workspaceResourceId,
    )
}
