@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.inputs

import com.pulumi.azurenative.containerinstance.inputs.VolumeMountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the volume mount.
 * @property mountPath The path within the container where the volume should be mounted. Must not contain colon (:).
 * @property name The name of the volume mount.
 * @property readOnly The flag indicating whether the volume mount is read-only.
 */
public data class VolumeMountArgs(
    public val mountPath: Output<String>,
    public val name: Output<String>,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerinstance.inputs.VolumeMountArgs> {
    override fun toJava(): com.pulumi.azurenative.containerinstance.inputs.VolumeMountArgs =
        com.pulumi.azurenative.containerinstance.inputs.VolumeMountArgs.builder()
            .mountPath(mountPath.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeMountArgs].
 */
@PulumiTagMarker
public class VolumeMountArgsBuilder internal constructor() {
    private var mountPath: Output<String>? = null

    private var name: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value The path within the container where the volume should be mounted. Must not contain colon (:).
     */
    @JvmName("wqttcxlkmhkgbdub")
    public suspend fun mountPath(`value`: Output<String>) {
        this.mountPath = value
    }

    /**
     * @param value The name of the volume mount.
     */
    @JvmName("fheorwwcuiovcecn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The flag indicating whether the volume mount is read-only.
     */
    @JvmName("hltgabqpvekwnudl")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value The path within the container where the volume should be mounted. Must not contain colon (:).
     */
    @JvmName("fdmpxnmgigmwlqbn")
    public suspend fun mountPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPath = mapped
    }

    /**
     * @param value The name of the volume mount.
     */
    @JvmName("tquwcclwcisetjkg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The flag indicating whether the volume mount is read-only.
     */
    @JvmName("srcrrpebgtahpxfh")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): VolumeMountArgs = VolumeMountArgs(
        mountPath = mountPath ?: throw PulumiNullFieldException("mountPath"),
        name = name ?: throw PulumiNullFieldException("name"),
        readOnly = readOnly,
    )
}
