@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties for confidential container group
 * @property ccePolicy The base64 encoded confidential compute enforcement policy
 */
public data class ConfidentialComputePropertiesResponse(
    public val ccePolicy: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ConfidentialComputePropertiesResponse): ConfidentialComputePropertiesResponse = ConfidentialComputePropertiesResponse(
            ccePolicy = javaType.ccePolicy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
