@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The container execution command, for liveness or readiness probe
 * @property command The commands to execute within the container.
 */
public data class ContainerExecResponse(
    public val command: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerExecResponse): ContainerExecResponse = ContainerExecResponse(
            command = javaType.command().map({ args0 -> args0 }),
        )
    }
}
