@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of the container group. Only valid in response.
 * @property events The events of this container group.
 * @property state The state of the container group. Only valid in response.
 */
public data class ContainerGroupPropertiesResponseInstanceView(
    public val events: List<EventResponse>,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerGroupPropertiesResponseInstanceView): ContainerGroupPropertiesResponseInstanceView = ContainerGroupPropertiesResponseInstanceView(
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.EventResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state(),
        )
    }
}
