@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The port exposed on the container instance.
 * @property port The port number exposed within the container group.
 * @property protocol The protocol associated with the port.
 */
public data class ContainerPortResponse(
    public val port: Int,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerPortResponse): ContainerPortResponse = ContainerPortResponse(
            port = javaType.port(),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
