@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The container instance state.
 * @property detailStatus The human-readable status of the container instance state.
 * @property exitCode The container instance exit codes correspond to those from the `docker run` command.
 * @property finishTime The date-time when the container instance state finished.
 * @property startTime The date-time when the container instance state started.
 * @property state The state of the container instance.
 */
public data class ContainerStateResponse(
    public val detailStatus: String,
    public val exitCode: Int,
    public val finishTime: String,
    public val startTime: String,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ContainerStateResponse): ContainerStateResponse = ContainerStateResponse(
            detailStatus = javaType.detailStatus(),
            exitCode = javaType.exitCode(),
            finishTime = javaType.finishTime(),
            startTime = javaType.startTime(),
            state = javaType.state(),
        )
    }
}
