@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Extension sidecars to be added to the deployment.
 * @property extensionType Type of extension to be added.
 * @property name Name of the extension.
 * @property protectedSettings Protected settings for the extension.
 * @property settings Settings for the extension.
 * @property version Version of the extension being used.
 */
public data class DeploymentExtensionSpecResponse(
    public val extensionType: String,
    public val name: String,
    public val protectedSettings: Any? = null,
    public val settings: Any? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.DeploymentExtensionSpecResponse): DeploymentExtensionSpecResponse = DeploymentExtensionSpecResponse(
            extensionType = javaType.extensionType(),
            name = javaType.name(),
            protectedSettings = javaType.protectedSettings().map({ args0 -> args0 }).orElse(null),
            settings = javaType.settings().map({ args0 -> args0 }).orElse(null),
            version = javaType.version(),
        )
    }
}
