@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DNS configuration for the container group.
 * @property nameServers The DNS servers for the container group.
 * @property options The DNS options for the container group.
 * @property searchDomains The DNS search domains for hostname lookup in the container group.
 */
public data class DnsConfigurationResponse(
    public val nameServers: List<String>,
    public val options: String? = null,
    public val searchDomains: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.DnsConfigurationResponse): DnsConfigurationResponse = DnsConfigurationResponse(
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            options = javaType.options().map({ args0 -> args0 }).orElse(null),
            searchDomains = javaType.searchDomains().map({ args0 -> args0 }).orElse(null),
        )
    }
}
