@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The container group encryption properties.
 * @property identity The keyvault managed identity.
 * @property keyName The encryption key name.
 * @property keyVersion The encryption key version.
 * @property vaultBaseUrl The keyvault base url.
 */
public data class EncryptionPropertiesResponse(
    public val identity: String? = null,
    public val keyName: String,
    public val keyVersion: String,
    public val vaultBaseUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.EncryptionPropertiesResponse): EncryptionPropertiesResponse = EncryptionPropertiesResponse(
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            keyName = javaType.keyName(),
            keyVersion = javaType.keyVersion(),
            vaultBaseUrl = javaType.vaultBaseUrl(),
        )
    }
}
