@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a volume that is populated with the contents of a git repository
 * @property directory Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
 * @property repository Repository URL
 * @property revision Commit hash for the specified revision.
 */
public data class GitRepoVolumeResponse(
    public val directory: String? = null,
    public val repository: String,
    public val revision: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.GitRepoVolumeResponse): GitRepoVolumeResponse = GitRepoVolumeResponse(
            directory = javaType.directory().map({ args0 -> args0 }).orElse(null),
            repository = javaType.repository(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
        )
    }
}
