@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Image registry credential.
 * @property identity The identity for the private registry.
 * @property identityUrl The identity URL for the private registry.
 * @property password The password for the private registry.
 * @property server The Docker image registry server without a protocol such as "http" and "https".
 * @property username The username for the private registry.
 */
public data class ImageRegistryCredentialResponse(
    public val identity: String? = null,
    public val identityUrl: String? = null,
    public val password: String? = null,
    public val server: String,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ImageRegistryCredentialResponse): ImageRegistryCredentialResponse = ImageRegistryCredentialResponse(
            identity = javaType.identity().map({ args0 -> args0 }).orElse(null),
            identityUrl = javaType.identityUrl().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            server = javaType.server(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
