@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * The instance view of the init container. Only valid in response.
 * @property currentState The current state of the init container.
 * @property events The events of the init container.
 * @property previousState The previous state of the init container.
 * @property restartCount The number of times that the init container has been restarted.
 */
public data class InitContainerPropertiesDefinitionResponseInstanceView(
    public val currentState: ContainerStateResponse,
    public val events: List<EventResponse>,
    public val previousState: ContainerStateResponse,
    public val restartCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.InitContainerPropertiesDefinitionResponseInstanceView): InitContainerPropertiesDefinitionResponseInstanceView =
            InitContainerPropertiesDefinitionResponseInstanceView(
                currentState = javaType.currentState().let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerStateResponse.Companion.toKotlin(args0)
                }),
                events = javaType.events().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.containerinstance.kotlin.outputs.EventResponse.Companion.toKotlin(args0)
                    })
                }),
                previousState = javaType.previousState().let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.ContainerStateResponse.Companion.toKotlin(args0)
                }),
                restartCount = javaType.restartCount(),
            )
    }
}
