@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * IP address for the container group.
 * @property autoGeneratedDomainNameLabelScope The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be reused within the same resource group, subscription, or tenant.
 * @property dnsNameLabel The Dns name label for the IP.
 * @property fqdn The FQDN for the IP.
 * @property ip The IP exposed to the public internet.
 * @property ports The list of ports exposed on the container group.
 * @property type Specifies if the IP is exposed to the public internet or private VNET.
 */
public data class IpAddressResponse(
    public val autoGeneratedDomainNameLabelScope: String? = null,
    public val dnsNameLabel: String? = null,
    public val fqdn: String,
    public val ip: String? = null,
    public val ports: List<PortResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.IpAddressResponse): IpAddressResponse = IpAddressResponse(
            autoGeneratedDomainNameLabelScope = javaType.autoGeneratedDomainNameLabelScope().map({ args0 ->
                args0
            }).orElse(null),
            dnsNameLabel = javaType.dnsNameLabel().map({ args0 -> args0 }).orElse(null),
            fqdn = javaType.fqdn(),
            ip = javaType.ip().map({ args0 -> args0 }).orElse(null),
            ports = javaType.ports().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.PortResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
