@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Container group log analytics information.
 * @property logType The log type to be used.
 * @property metadata Metadata for log analytics.
 * @property workspaceId The workspace id for log analytics
 * @property workspaceKey The workspace key for log analytics
 * @property workspaceResourceId The workspace resource id for log analytics
 */
public data class LogAnalyticsResponse(
    public val logType: String? = null,
    public val metadata: Map<String, String>? = null,
    public val workspaceId: String,
    public val workspaceKey: String,
    public val workspaceResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.LogAnalyticsResponse): LogAnalyticsResponse = LogAnalyticsResponse(
            logType = javaType.logType().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            workspaceId = javaType.workspaceId(),
            workspaceKey = javaType.workspaceKey(),
            workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
