@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerinstance.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 * The resource requests.
 * @property cpu The CPU request of this container instance.
 * @property gpu The GPU request of this container instance.
 * @property memoryInGB The memory request in GB of this container instance.
 */
public data class ResourceRequestsResponse(
    public val cpu: Double,
    public val gpu: GpuResourceResponse? = null,
    public val memoryInGB: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerinstance.outputs.ResourceRequestsResponse): ResourceRequestsResponse = ResourceRequestsResponse(
            cpu = javaType.cpu(),
            gpu = javaType.gpu().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.containerinstance.kotlin.outputs.GpuResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            memoryInGB = javaType.memoryInGB(),
        )
    }
}
