@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AgentPool].
 */
@PulumiTagMarker
public class AgentPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AgentPoolArgs = AgentPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AgentPoolArgsBuilder.() -> Unit) {
        val builder = AgentPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AgentPool {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.AgentPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AgentPool(builtJavaResource)
    }
}

/**
 * The agentpool that has the ARM resource and properties.
 * The agentpool will have all information to create an agent pool.
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### AgentPools_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var agentPool = new AzureNative.ContainerRegistry.AgentPool("agentPool", new()
 *     {
 *         AgentPoolName = "myAgentPool",
 *         Count = 1,
 *         Location = "WESTUS",
 *         Os = AzureNative.ContainerRegistry.OS.Linux,
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         Tier = "S1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewAgentPool(ctx, "agentPool", &containerregistry.AgentPoolArgs{
 * 			AgentPoolName:     pulumi.String("myAgentPool"),
 * 			Count:             pulumi.Int(1),
 * 			Location:          pulumi.String("WESTUS"),
 * 			Os:                pulumi.String(containerregistry.OSLinux),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			Tier: pulumi.String("S1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.AgentPool;
 * import com.pulumi.azurenative.containerregistry.AgentPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var agentPool = new AgentPool("agentPool", AgentPoolArgs.builder()
 *             .agentPoolName("myAgentPool")
 *             .count(1)
 *             .location("WESTUS")
 *             .os("Linux")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key", "value"))
 *             .tier("S1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:AgentPool myAgentPool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/agentPools/{agentPoolName}
 * ```
 */
public class AgentPool internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.AgentPool,
) : KotlinCustomResource(javaResource, AgentPoolMapper) {
    /**
     * The count of agent machine
     */
    public val count: Output<Int>?
        get() = javaResource.count().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The location of the resource. This cannot be changed after the resource is created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The OS of agent machine
     */
    public val os: Output<String>?
        get() = javaResource.os().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of this agent pool
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The Tier of agent machine
     */
    public val tier: Output<String>?
        get() = javaResource.tier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Virtual Network Subnet Resource Id of the agent machine
     */
    public val virtualNetworkSubnetResourceId: Output<String>?
        get() = javaResource.virtualNetworkSubnetResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AgentPoolMapper : ResourceMapper<AgentPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.AgentPool::class == javaResource::class

    override fun map(javaResource: Resource): AgentPool = AgentPool(
        javaResource as
            com.pulumi.azurenative.containerregistry.AgentPool,
    )
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AgentPool].
 */
public suspend fun agentPool(name: String, block: suspend AgentPoolResourceBuilder.() -> Unit): AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AgentPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun agentPool(name: String): AgentPool {
    val builder = AgentPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
