@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.ArchivePackageSourcePropertiesResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ArchivePackageSourcePropertiesResponse.Companion.toKotlin as archivePackageSourcePropertiesResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Archife].
 */
@PulumiTagMarker
public class ArchifeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArchifeArgs = ArchifeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArchifeArgsBuilder.() -> Unit) {
        val builder = ArchifeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Archife {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.Archife(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Archife(builtJavaResource)
    }
}

/**
 * An object that represents a archive for a container registry.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ArchiveCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var archife = new AzureNative.ContainerRegistry.Archife("archife", new()
 *     {
 *         ArchiveName = "myArchiveName",
 *         PackageSource = new AzureNative.ContainerRegistry.Inputs.ArchivePackageSourcePropertiesArgs
 *         {
 *             Type = AzureNative.ContainerRegistry.PackageSourceType.Remote,
 *             Url = "string",
 *         },
 *         PackageType = "rpm",
 *         PublishedVersion = "string",
 *         RegistryName = "myRegistry",
 *         RepositoryEndpointPrefix = "string",
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewArchife(ctx, "archife", &containerregistry.ArchifeArgs{
 * 			ArchiveName: pulumi.String("myArchiveName"),
 * 			PackageSource: &containerregistry.ArchivePackageSourcePropertiesArgs{
 * 				Type: pulumi.String(containerregistry.PackageSourceTypeRemote),
 * 				Url:  pulumi.String("string"),
 * 			},
 * 			PackageType:              pulumi.String("rpm"),
 * 			PublishedVersion:         pulumi.String("string"),
 * 			RegistryName:             pulumi.String("myRegistry"),
 * 			RepositoryEndpointPrefix: pulumi.String("string"),
 * 			ResourceGroupName:        pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Archife;
 * import com.pulumi.azurenative.containerregistry.ArchifeArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.ArchivePackageSourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var archife = new Archife("archife", ArchifeArgs.builder()
 *             .archiveName("myArchiveName")
 *             .packageSource(ArchivePackageSourcePropertiesArgs.builder()
 *                 .type("remote")
 *                 .url("string")
 *                 .build())
 *             .packageType("rpm")
 *             .publishedVersion("string")
 *             .registryName("myRegistry")
 *             .repositoryEndpointPrefix("string")
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Archife myArchiveName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/packages/{packageType}/archives/{archiveName}
 * ```
 */
public class Archife internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.Archife,
) : KotlinCustomResource(javaResource, ArchifeMapper) {
    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The package source of the archive.
     */
    public val packageSource: Output<ArchivePackageSourcePropertiesResponse>?
        get() = javaResource.packageSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> archivePackageSourcePropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the archive at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The published version of the archive.
     */
    public val publishedVersion: Output<String>?
        get() = javaResource.publishedVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val repositoryEndpoint: Output<String>
        get() = javaResource.repositoryEndpoint().applyValue({ args0 -> args0 })

    public val repositoryEndpointPrefix: Output<String>?
        get() = javaResource.repositoryEndpointPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ArchifeMapper : ResourceMapper<Archife> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.Archife::class == javaResource::class

    override fun map(javaResource: Resource): Archife = Archife(
        javaResource as
            com.pulumi.azurenative.containerregistry.Archife,
    )
}

/**
 * @see [Archife].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Archife].
 */
public suspend fun archife(name: String, block: suspend ArchifeResourceBuilder.() -> Unit): Archife {
    val builder = ArchifeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Archife].
 * @param name The _unique_ name of the resulting resource.
 */
public fun archife(name: String): Archife {
    val builder = ArchifeResourceBuilder()
    builder.name(name)
    return builder.build()
}
