@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getAgentPoolPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getArchifePlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getArchiveVersionPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getCacheRulePlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getConnectedRegistryPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getCredentialSetPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getExportPipelinePlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getImportPipelinePlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getPipelineRunPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getRegistryPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getReplicationPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getScopeMapPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getTaskPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getTaskRunPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getTokenPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getWebhookCallbackConfigPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.getWebhookPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.listAgentPoolQueueStatusPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.listRegistryBuildSourceUploadUrlPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.listRegistryCredentialsPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.listRunLogSasUrlPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.listTaskDetailsPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.listTaskRunDetailsPlain
import com.pulumi.azurenative.containerregistry.ContainerregistryFunctions.listWebhookEventsPlain
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetAgentPoolPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetAgentPoolPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetArchifePlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetArchifePlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetArchiveVersionPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetArchiveVersionPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetCacheRulePlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetCacheRulePlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetConnectedRegistryPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetConnectedRegistryPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetCredentialSetPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetCredentialSetPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetExportPipelinePlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetExportPipelinePlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetImportPipelinePlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetImportPipelinePlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetPipelineRunPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetPipelineRunPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetRegistryPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetRegistryPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetReplicationPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetReplicationPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetScopeMapPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetScopeMapPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetTaskPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetTaskPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetTaskRunPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetTaskRunPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetTokenPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetTokenPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetWebhookCallbackConfigPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetWebhookCallbackConfigPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetWebhookPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.GetWebhookPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListAgentPoolQueueStatusPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListAgentPoolQueueStatusPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListRegistryBuildSourceUploadUrlPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListRegistryBuildSourceUploadUrlPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListRegistryCredentialsPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListRegistryCredentialsPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListRunLogSasUrlPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListRunLogSasUrlPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListTaskDetailsPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListTaskDetailsPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListTaskRunDetailsPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListTaskRunDetailsPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListWebhookEventsPlainArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.ListWebhookEventsPlainArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetAgentPoolResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetArchifeResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetArchiveVersionResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetCacheRuleResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetConnectedRegistryResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetCredentialSetResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetExportPipelineResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetImportPipelineResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetPipelineRunResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetRegistryResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetReplicationResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetScopeMapResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetTaskResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetTaskRunResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetTokenResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetWebhookCallbackConfigResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetWebhookResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListAgentPoolQueueStatusResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListRegistryBuildSourceUploadUrlResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListRegistryCredentialsResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListRunLogSasUrlResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListTaskDetailsResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListTaskRunDetailsResult
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListWebhookEventsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetAgentPoolResult.Companion.toKotlin as getAgentPoolResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetArchifeResult.Companion.toKotlin as getArchifeResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetArchiveVersionResult.Companion.toKotlin as getArchiveVersionResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetCacheRuleResult.Companion.toKotlin as getCacheRuleResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetConnectedRegistryResult.Companion.toKotlin as getConnectedRegistryResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetCredentialSetResult.Companion.toKotlin as getCredentialSetResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetExportPipelineResult.Companion.toKotlin as getExportPipelineResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetImportPipelineResult.Companion.toKotlin as getImportPipelineResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetPipelineRunResult.Companion.toKotlin as getPipelineRunResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetRegistryResult.Companion.toKotlin as getRegistryResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetReplicationResult.Companion.toKotlin as getReplicationResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetScopeMapResult.Companion.toKotlin as getScopeMapResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetTaskResult.Companion.toKotlin as getTaskResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetTaskRunResult.Companion.toKotlin as getTaskRunResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetTokenResult.Companion.toKotlin as getTokenResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetWebhookCallbackConfigResult.Companion.toKotlin as getWebhookCallbackConfigResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.GetWebhookResult.Companion.toKotlin as getWebhookResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListAgentPoolQueueStatusResult.Companion.toKotlin as listAgentPoolQueueStatusResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListRegistryBuildSourceUploadUrlResult.Companion.toKotlin as listRegistryBuildSourceUploadUrlResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListRegistryCredentialsResult.Companion.toKotlin as listRegistryCredentialsResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListRunLogSasUrlResult.Companion.toKotlin as listRunLogSasUrlResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListTaskDetailsResult.Companion.toKotlin as listTaskDetailsResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListTaskRunDetailsResult.Companion.toKotlin as listTaskRunDetailsResultToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.ListWebhookEventsResult.Companion.toKotlin as listWebhookEventsResultToKotlin

public object ContainerregistryFunctions {
    /**
     * Gets the detailed information for a given agent pool.
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The agentpool that has the ARM resource and properties.
     * The agentpool will have all information to create an agent pool.
     */
    public suspend fun getAgentPool(argument: GetAgentPoolPlainArgs): GetAgentPoolResult =
        getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())

    /**
     * @see [getAgentPool].
     * @param agentPoolName The name of the agent pool.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @return The agentpool that has the ARM resource and properties.
     * The agentpool will have all information to create an agent pool.
     */
    public suspend fun getAgentPool(
        agentPoolName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetAgentPoolResult {
        val argument = GetAgentPoolPlainArgs(
            agentPoolName = agentPoolName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getAgentPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetAgentPoolPlainArgs].
     * @return The agentpool that has the ARM resource and properties.
     * The agentpool will have all information to create an agent pool.
     */
    public suspend fun getAgentPool(argument: suspend GetAgentPoolPlainArgsBuilder.() -> Unit): GetAgentPoolResult {
        val builder = GetAgentPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAgentPoolResultToKotlin(getAgentPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the archive.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a archive for a container registry.
     */
    public suspend fun getArchife(argument: GetArchifePlainArgs): GetArchifeResult =
        getArchifeResultToKotlin(getArchifePlain(argument.toJava()).await())

    /**
     * @see [getArchife].
     * @param archiveName The name of the archive resource.
     * @param packageType The type of the package resource.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a archive for a container registry.
     */
    public suspend fun getArchife(
        archiveName: String,
        packageType: String,
        registryName: String,
        resourceGroupName: String,
    ): GetArchifeResult {
        val argument = GetArchifePlainArgs(
            archiveName = archiveName,
            packageType = packageType,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getArchifeResultToKotlin(getArchifePlain(argument.toJava()).await())
    }

    /**
     * @see [getArchife].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetArchifePlainArgs].
     * @return An object that represents a archive for a container registry.
     */
    public suspend fun getArchife(argument: suspend GetArchifePlainArgsBuilder.() -> Unit): GetArchifeResult {
        val builder = GetArchifePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArchifeResultToKotlin(getArchifePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the archive version.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents an export pipeline for a container registry.
     */
    public suspend fun getArchiveVersion(argument: GetArchiveVersionPlainArgs): GetArchiveVersionResult =
        getArchiveVersionResultToKotlin(getArchiveVersionPlain(argument.toJava()).await())

    /**
     * @see [getArchiveVersion].
     * @param archiveName The name of the archive resource.
     * @param archiveVersionName The name of the archive version resource.
     * @param packageType The type of the package resource.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents an export pipeline for a container registry.
     */
    public suspend fun getArchiveVersion(
        archiveName: String,
        archiveVersionName: String,
        packageType: String,
        registryName: String,
        resourceGroupName: String,
    ): GetArchiveVersionResult {
        val argument = GetArchiveVersionPlainArgs(
            archiveName = archiveName,
            archiveVersionName = archiveVersionName,
            packageType = packageType,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getArchiveVersionResultToKotlin(getArchiveVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getArchiveVersion].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetArchiveVersionPlainArgs].
     * @return An object that represents an export pipeline for a container registry.
     */
    public suspend fun getArchiveVersion(argument: suspend GetArchiveVersionPlainArgsBuilder.() -> Unit): GetArchiveVersionResult {
        val builder = GetArchiveVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArchiveVersionResultToKotlin(getArchiveVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified cache rule resource.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a cache rule for a container registry.
     */
    public suspend fun getCacheRule(argument: GetCacheRulePlainArgs): GetCacheRuleResult =
        getCacheRuleResultToKotlin(getCacheRulePlain(argument.toJava()).await())

    /**
     * @see [getCacheRule].
     * @param cacheRuleName The name of the cache rule.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a cache rule for a container registry.
     */
    public suspend fun getCacheRule(
        cacheRuleName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetCacheRuleResult {
        val argument = GetCacheRulePlainArgs(
            cacheRuleName = cacheRuleName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getCacheRuleResultToKotlin(getCacheRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getCacheRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetCacheRulePlainArgs].
     * @return An object that represents a cache rule for a container registry.
     */
    public suspend fun getCacheRule(argument: suspend GetCacheRulePlainArgsBuilder.() -> Unit): GetCacheRuleResult {
        val builder = GetCacheRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCacheRuleResultToKotlin(getCacheRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the connected registry.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a connected registry for a container registry.
     */
    public suspend fun getConnectedRegistry(argument: GetConnectedRegistryPlainArgs): GetConnectedRegistryResult =
        getConnectedRegistryResultToKotlin(getConnectedRegistryPlain(argument.toJava()).await())

    /**
     * @see [getConnectedRegistry].
     * @param connectedRegistryName The name of the connected registry.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a connected registry for a container registry.
     */
    public suspend fun getConnectedRegistry(
        connectedRegistryName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetConnectedRegistryResult {
        val argument = GetConnectedRegistryPlainArgs(
            connectedRegistryName = connectedRegistryName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectedRegistryResultToKotlin(getConnectedRegistryPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectedRegistry].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetConnectedRegistryPlainArgs].
     * @return An object that represents a connected registry for a container registry.
     */
    public suspend fun getConnectedRegistry(argument: suspend GetConnectedRegistryPlainArgsBuilder.() -> Unit): GetConnectedRegistryResult {
        val builder = GetConnectedRegistryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectedRegistryResultToKotlin(getConnectedRegistryPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified credential set resource.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a credential set resource for a container registry.
     */
    public suspend fun getCredentialSet(argument: GetCredentialSetPlainArgs): GetCredentialSetResult =
        getCredentialSetResultToKotlin(getCredentialSetPlain(argument.toJava()).await())

    /**
     * @see [getCredentialSet].
     * @param credentialSetName The name of the credential set.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a credential set resource for a container registry.
     */
    public suspend fun getCredentialSet(
        credentialSetName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetCredentialSetResult {
        val argument = GetCredentialSetPlainArgs(
            credentialSetName = credentialSetName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getCredentialSetResultToKotlin(getCredentialSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getCredentialSet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetCredentialSetPlainArgs].
     * @return An object that represents a credential set resource for a container registry.
     */
    public suspend fun getCredentialSet(argument: suspend GetCredentialSetPlainArgsBuilder.() -> Unit): GetCredentialSetResult {
        val builder = GetCredentialSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCredentialSetResultToKotlin(getCredentialSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the export pipeline.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents an export pipeline for a container registry.
     */
    public suspend fun getExportPipeline(argument: GetExportPipelinePlainArgs): GetExportPipelineResult =
        getExportPipelineResultToKotlin(getExportPipelinePlain(argument.toJava()).await())

    /**
     * @see [getExportPipeline].
     * @param exportPipelineName The name of the export pipeline.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents an export pipeline for a container registry.
     */
    public suspend fun getExportPipeline(
        exportPipelineName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetExportPipelineResult {
        val argument = GetExportPipelinePlainArgs(
            exportPipelineName = exportPipelineName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getExportPipelineResultToKotlin(getExportPipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getExportPipeline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetExportPipelinePlainArgs].
     * @return An object that represents an export pipeline for a container registry.
     */
    public suspend fun getExportPipeline(argument: suspend GetExportPipelinePlainArgsBuilder.() -> Unit): GetExportPipelineResult {
        val builder = GetExportPipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExportPipelineResultToKotlin(getExportPipelinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the import pipeline.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents an import pipeline for a container registry.
     */
    public suspend fun getImportPipeline(argument: GetImportPipelinePlainArgs): GetImportPipelineResult =
        getImportPipelineResultToKotlin(getImportPipelinePlain(argument.toJava()).await())

    /**
     * @see [getImportPipeline].
     * @param importPipelineName The name of the import pipeline.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents an import pipeline for a container registry.
     */
    public suspend fun getImportPipeline(
        importPipelineName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetImportPipelineResult {
        val argument = GetImportPipelinePlainArgs(
            importPipelineName = importPipelineName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getImportPipelineResultToKotlin(getImportPipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getImportPipeline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetImportPipelinePlainArgs].
     * @return An object that represents an import pipeline for a container registry.
     */
    public suspend fun getImportPipeline(argument: suspend GetImportPipelinePlainArgsBuilder.() -> Unit): GetImportPipelineResult {
        val builder = GetImportPipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getImportPipelineResultToKotlin(getImportPipelinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the detailed information for a given pipeline run.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-06-01-preview, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a pipeline run for a container registry.
     */
    public suspend fun getPipelineRun(argument: GetPipelineRunPlainArgs): GetPipelineRunResult =
        getPipelineRunResultToKotlin(getPipelineRunPlain(argument.toJava()).await())

    /**
     * @see [getPipelineRun].
     * @param pipelineRunName The name of the pipeline run.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a pipeline run for a container registry.
     */
    public suspend fun getPipelineRun(
        pipelineRunName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetPipelineRunResult {
        val argument = GetPipelineRunPlainArgs(
            pipelineRunName = pipelineRunName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getPipelineRunResultToKotlin(getPipelineRunPlain(argument.toJava()).await())
    }

    /**
     * @see [getPipelineRun].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetPipelineRunPlainArgs].
     * @return An object that represents a pipeline run for a container registry.
     */
    public suspend fun getPipelineRun(argument: suspend GetPipelineRunPlainArgsBuilder.() -> Unit): GetPipelineRunResult {
        val builder = GetPipelineRunPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineRunResultToKotlin(getPipelineRunPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the specified private endpoint connection associated with the container registry.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a private endpoint connection for a container registry.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a private endpoint connection for a container registry.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        registryName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return An object that represents a private endpoint connection for a container registry.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified container registry.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2017-03-01, 2019-05-01, 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a container registry.
     */
    public suspend fun getRegistry(argument: GetRegistryPlainArgs): GetRegistryResult =
        getRegistryResultToKotlin(getRegistryPlain(argument.toJava()).await())

    /**
     * @see [getRegistry].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a container registry.
     */
    public suspend fun getRegistry(registryName: String, resourceGroupName: String): GetRegistryResult {
        val argument = GetRegistryPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return getRegistryResultToKotlin(getRegistryPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegistry].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetRegistryPlainArgs].
     * @return An object that represents a container registry.
     */
    public suspend fun getRegistry(argument: suspend GetRegistryPlainArgsBuilder.() -> Unit): GetRegistryResult {
        val builder = GetRegistryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegistryResultToKotlin(getRegistryPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified replication.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a replication for a container registry.
     */
    public suspend fun getReplication(argument: GetReplicationPlainArgs): GetReplicationResult =
        getReplicationResultToKotlin(getReplicationPlain(argument.toJava()).await())

    /**
     * @see [getReplication].
     * @param registryName The name of the container registry.
     * @param replicationName The name of the replication.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An object that represents a replication for a container registry.
     */
    public suspend fun getReplication(
        registryName: String,
        replicationName: String,
        resourceGroupName: String,
    ): GetReplicationResult {
        val argument = GetReplicationPlainArgs(
            registryName = registryName,
            replicationName = replicationName,
            resourceGroupName = resourceGroupName,
        )
        return getReplicationResultToKotlin(getReplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetReplicationPlainArgs].
     * @return An object that represents a replication for a container registry.
     */
    public suspend fun getReplication(argument: suspend GetReplicationPlainArgsBuilder.() -> Unit): GetReplicationResult {
        val builder = GetReplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationResultToKotlin(getReplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified scope map.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a scope map for a container registry.
     */
    public suspend fun getScopeMap(argument: GetScopeMapPlainArgs): GetScopeMapResult =
        getScopeMapResultToKotlin(getScopeMapPlain(argument.toJava()).await())

    /**
     * @see [getScopeMap].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param scopeMapName The name of the scope map.
     * @return An object that represents a scope map for a container registry.
     */
    public suspend fun getScopeMap(
        registryName: String,
        resourceGroupName: String,
        scopeMapName: String,
    ): GetScopeMapResult {
        val argument = GetScopeMapPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            scopeMapName = scopeMapName,
        )
        return getScopeMapResultToKotlin(getScopeMapPlain(argument.toJava()).await())
    }

    /**
     * @see [getScopeMap].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetScopeMapPlainArgs].
     * @return An object that represents a scope map for a container registry.
     */
    public suspend fun getScopeMap(argument: suspend GetScopeMapPlainArgsBuilder.() -> Unit): GetScopeMapResult {
        val builder = GetScopeMapPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getScopeMapResultToKotlin(getScopeMapPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the properties of a specified task.
     * Azure REST API version: 2019-06-01-preview.
     * Other available API versions: 2018-09-01, 2019-04-01.
     * @param argument null
     * @return The task that has the ARM resource and task properties.
     * The task will have all information to schedule a run against it.
     */
    public suspend fun getTask(argument: GetTaskPlainArgs): GetTaskResult =
        getTaskResultToKotlin(getTaskPlain(argument.toJava()).await())

    /**
     * @see [getTask].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param taskName The name of the container registry task.
     * @return The task that has the ARM resource and task properties.
     * The task will have all information to schedule a run against it.
     */
    public suspend fun getTask(
        registryName: String,
        resourceGroupName: String,
        taskName: String,
    ): GetTaskResult {
        val argument = GetTaskPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            taskName = taskName,
        )
        return getTaskResultToKotlin(getTaskPlain(argument.toJava()).await())
    }

    /**
     * @see [getTask].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetTaskPlainArgs].
     * @return The task that has the ARM resource and task properties.
     * The task will have all information to schedule a run against it.
     */
    public suspend fun getTask(argument: suspend GetTaskPlainArgsBuilder.() -> Unit): GetTaskResult {
        val builder = GetTaskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTaskResultToKotlin(getTaskPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the detailed information for a given task run.
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The task run that has the ARM resource and properties.
     * The task run will have the information of request and result of a run.
     */
    public suspend fun getTaskRun(argument: GetTaskRunPlainArgs): GetTaskRunResult =
        getTaskRunResultToKotlin(getTaskRunPlain(argument.toJava()).await())

    /**
     * @see [getTaskRun].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param taskRunName The name of the task run.
     * @return The task run that has the ARM resource and properties.
     * The task run will have the information of request and result of a run.
     */
    public suspend fun getTaskRun(
        registryName: String,
        resourceGroupName: String,
        taskRunName: String,
    ): GetTaskRunResult {
        val argument = GetTaskRunPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            taskRunName = taskRunName,
        )
        return getTaskRunResultToKotlin(getTaskRunPlain(argument.toJava()).await())
    }

    /**
     * @see [getTaskRun].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetTaskRunPlainArgs].
     * @return The task run that has the ARM resource and properties.
     * The task run will have the information of request and result of a run.
     */
    public suspend fun getTaskRun(argument: suspend GetTaskRunPlainArgsBuilder.() -> Unit): GetTaskRunResult {
        val builder = GetTaskRunPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTaskRunResultToKotlin(getTaskRunPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified token.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a token for a container registry.
     */
    public suspend fun getToken(argument: GetTokenPlainArgs): GetTokenResult =
        getTokenResultToKotlin(getTokenPlain(argument.toJava()).await())

    /**
     * @see [getToken].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param tokenName The name of the token.
     * @return An object that represents a token for a container registry.
     */
    public suspend fun getToken(
        registryName: String,
        resourceGroupName: String,
        tokenName: String,
    ): GetTokenResult {
        val argument = GetTokenPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            tokenName = tokenName,
        )
        return getTokenResultToKotlin(getTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetTokenPlainArgs].
     * @return An object that represents a token for a container registry.
     */
    public suspend fun getToken(argument: suspend GetTokenPlainArgsBuilder.() -> Unit): GetTokenResult {
        val builder = GetTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTokenResultToKotlin(getTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the properties of the specified webhook.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return An object that represents a webhook for a container registry.
     */
    public suspend fun getWebhook(argument: GetWebhookPlainArgs): GetWebhookResult =
        getWebhookResultToKotlin(getWebhookPlain(argument.toJava()).await())

    /**
     * @see [getWebhook].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param webhookName The name of the webhook.
     * @return An object that represents a webhook for a container registry.
     */
    public suspend fun getWebhook(
        registryName: String,
        resourceGroupName: String,
        webhookName: String,
    ): GetWebhookResult {
        val argument = GetWebhookPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            webhookName = webhookName,
        )
        return getWebhookResultToKotlin(getWebhookPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebhook].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetWebhookPlainArgs].
     * @return An object that represents a webhook for a container registry.
     */
    public suspend fun getWebhook(argument: suspend GetWebhookPlainArgsBuilder.() -> Unit): GetWebhookResult {
        val builder = GetWebhookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebhookResultToKotlin(getWebhookPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the configuration of service URI and custom headers for the webhook.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The configuration of service URI and custom headers for the webhook.
     */
    public suspend fun getWebhookCallbackConfig(argument: GetWebhookCallbackConfigPlainArgs): GetWebhookCallbackConfigResult =
        getWebhookCallbackConfigResultToKotlin(getWebhookCallbackConfigPlain(argument.toJava()).await())

    /**
     * @see [getWebhookCallbackConfig].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param webhookName The name of the webhook.
     * @return The configuration of service URI and custom headers for the webhook.
     */
    public suspend fun getWebhookCallbackConfig(
        registryName: String,
        resourceGroupName: String,
        webhookName: String,
    ): GetWebhookCallbackConfigResult {
        val argument = GetWebhookCallbackConfigPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            webhookName = webhookName,
        )
        return getWebhookCallbackConfigResultToKotlin(getWebhookCallbackConfigPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebhookCallbackConfig].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;GetWebhookCallbackConfigPlainArgs].
     * @return The configuration of service URI and custom headers for the webhook.
     */
    public suspend fun getWebhookCallbackConfig(argument: suspend GetWebhookCallbackConfigPlainArgsBuilder.() -> Unit): GetWebhookCallbackConfigResult {
        val builder = GetWebhookCallbackConfigPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebhookCallbackConfigResultToKotlin(getWebhookCallbackConfigPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the count of queued runs for a given agent pool.
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The QueueStatus of Agent Pool
     */
    public suspend fun listAgentPoolQueueStatus(argument: ListAgentPoolQueueStatusPlainArgs): ListAgentPoolQueueStatusResult =
        listAgentPoolQueueStatusResultToKotlin(listAgentPoolQueueStatusPlain(argument.toJava()).await())

    /**
     * @see [listAgentPoolQueueStatus].
     * @param agentPoolName The name of the agent pool.
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @return The QueueStatus of Agent Pool
     */
    public suspend fun listAgentPoolQueueStatus(
        agentPoolName: String,
        registryName: String,
        resourceGroupName: String,
    ): ListAgentPoolQueueStatusResult {
        val argument = ListAgentPoolQueueStatusPlainArgs(
            agentPoolName = agentPoolName,
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return listAgentPoolQueueStatusResultToKotlin(listAgentPoolQueueStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [listAgentPoolQueueStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;ListAgentPoolQueueStatusPlainArgs].
     * @return The QueueStatus of Agent Pool
     */
    public suspend fun listAgentPoolQueueStatus(argument: suspend ListAgentPoolQueueStatusPlainArgsBuilder.() -> Unit): ListAgentPoolQueueStatusResult {
        val builder = ListAgentPoolQueueStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAgentPoolQueueStatusResultToKotlin(listAgentPoolQueueStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the upload location for the user to be able to upload the source.
     * Azure REST API version: 2019-06-01-preview.
     * Other available API versions: 2018-09-01, 2019-04-01.
     * @param argument null
     * @return The properties of a response to source upload request.
     */
    public suspend fun listRegistryBuildSourceUploadUrl(argument: ListRegistryBuildSourceUploadUrlPlainArgs): ListRegistryBuildSourceUploadUrlResult =
        listRegistryBuildSourceUploadUrlResultToKotlin(listRegistryBuildSourceUploadUrlPlain(argument.toJava()).await())

    /**
     * @see [listRegistryBuildSourceUploadUrl].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @return The properties of a response to source upload request.
     */
    public suspend fun listRegistryBuildSourceUploadUrl(
        registryName: String,
        resourceGroupName: String,
    ): ListRegistryBuildSourceUploadUrlResult {
        val argument = ListRegistryBuildSourceUploadUrlPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return listRegistryBuildSourceUploadUrlResultToKotlin(listRegistryBuildSourceUploadUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listRegistryBuildSourceUploadUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;ListRegistryBuildSourceUploadUrlPlainArgs].
     * @return The properties of a response to source upload request.
     */
    public suspend fun listRegistryBuildSourceUploadUrl(argument: suspend ListRegistryBuildSourceUploadUrlPlainArgsBuilder.() -> Unit): ListRegistryBuildSourceUploadUrlResult {
        val builder = ListRegistryBuildSourceUploadUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRegistryBuildSourceUploadUrlResultToKotlin(listRegistryBuildSourceUploadUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists the login credentials for the specified container registry.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2017-03-01, 2019-05-01, 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The response from the ListCredentials operation.
     */
    public suspend fun listRegistryCredentials(argument: ListRegistryCredentialsPlainArgs): ListRegistryCredentialsResult =
        listRegistryCredentialsResultToKotlin(listRegistryCredentialsPlain(argument.toJava()).await())

    /**
     * @see [listRegistryCredentials].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The response from the ListCredentials operation.
     */
    public suspend fun listRegistryCredentials(registryName: String, resourceGroupName: String): ListRegistryCredentialsResult {
        val argument = ListRegistryCredentialsPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
        )
        return listRegistryCredentialsResultToKotlin(listRegistryCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [listRegistryCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;ListRegistryCredentialsPlainArgs].
     * @return The response from the ListCredentials operation.
     */
    public suspend fun listRegistryCredentials(argument: suspend ListRegistryCredentialsPlainArgsBuilder.() -> Unit): ListRegistryCredentialsResult {
        val builder = ListRegistryCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRegistryCredentialsResultToKotlin(listRegistryCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a link to download the run logs.
     * Azure REST API version: 2019-06-01-preview.
     * Other available API versions: 2018-09-01, 2019-04-01.
     * @param argument null
     * @return The result of get log link operation.
     */
    public suspend fun listRunLogSasUrl(argument: ListRunLogSasUrlPlainArgs): ListRunLogSasUrlResult =
        listRunLogSasUrlResultToKotlin(listRunLogSasUrlPlain(argument.toJava()).await())

    /**
     * @see [listRunLogSasUrl].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param runId The run ID.
     * @return The result of get log link operation.
     */
    public suspend fun listRunLogSasUrl(
        registryName: String,
        resourceGroupName: String,
        runId: String,
    ): ListRunLogSasUrlResult {
        val argument = ListRunLogSasUrlPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            runId = runId,
        )
        return listRunLogSasUrlResultToKotlin(listRunLogSasUrlPlain(argument.toJava()).await())
    }

    /**
     * @see [listRunLogSasUrl].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;ListRunLogSasUrlPlainArgs].
     * @return The result of get log link operation.
     */
    public suspend fun listRunLogSasUrl(argument: suspend ListRunLogSasUrlPlainArgsBuilder.() -> Unit): ListRunLogSasUrlResult {
        val builder = ListRunLogSasUrlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listRunLogSasUrlResultToKotlin(listRunLogSasUrlPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a task with extended information that includes all secrets.
     * Azure REST API version: 2019-06-01-preview.
     * Other available API versions: 2018-09-01, 2019-04-01.
     * @param argument null
     * @return The task that has the ARM resource and task properties.
     * The task will have all information to schedule a run against it.
     */
    public suspend fun listTaskDetails(argument: ListTaskDetailsPlainArgs): ListTaskDetailsResult =
        listTaskDetailsResultToKotlin(listTaskDetailsPlain(argument.toJava()).await())

    /**
     * @see [listTaskDetails].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param taskName The name of the container registry task.
     * @return The task that has the ARM resource and task properties.
     * The task will have all information to schedule a run against it.
     */
    public suspend fun listTaskDetails(
        registryName: String,
        resourceGroupName: String,
        taskName: String,
    ): ListTaskDetailsResult {
        val argument = ListTaskDetailsPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            taskName = taskName,
        )
        return listTaskDetailsResultToKotlin(listTaskDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listTaskDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;ListTaskDetailsPlainArgs].
     * @return The task that has the ARM resource and task properties.
     * The task will have all information to schedule a run against it.
     */
    public suspend fun listTaskDetails(argument: suspend ListTaskDetailsPlainArgsBuilder.() -> Unit): ListTaskDetailsResult {
        val builder = ListTaskDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listTaskDetailsResultToKotlin(listTaskDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the detailed information for a given task run that includes all secrets.
     * Azure REST API version: 2019-06-01-preview.
     * @param argument null
     * @return The task run that has the ARM resource and properties.
     * The task run will have the information of request and result of a run.
     */
    public suspend fun listTaskRunDetails(argument: ListTaskRunDetailsPlainArgs): ListTaskRunDetailsResult =
        listTaskRunDetailsResultToKotlin(listTaskRunDetailsPlain(argument.toJava()).await())

    /**
     * @see [listTaskRunDetails].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group to which the container registry belongs.
     * @param taskRunName The name of the task run.
     * @return The task run that has the ARM resource and properties.
     * The task run will have the information of request and result of a run.
     */
    public suspend fun listTaskRunDetails(
        registryName: String,
        resourceGroupName: String,
        taskRunName: String,
    ): ListTaskRunDetailsResult {
        val argument = ListTaskRunDetailsPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            taskRunName = taskRunName,
        )
        return listTaskRunDetailsResultToKotlin(listTaskRunDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [listTaskRunDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;ListTaskRunDetailsPlainArgs].
     * @return The task run that has the ARM resource and properties.
     * The task run will have the information of request and result of a run.
     */
    public suspend fun listTaskRunDetails(argument: suspend ListTaskRunDetailsPlainArgsBuilder.() -> Unit): ListTaskRunDetailsResult {
        val builder = ListTaskRunDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listTaskRunDetailsResultToKotlin(listTaskRunDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Lists recent events for the specified webhook.
     * Azure REST API version: 2022-12-01.
     * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
     * @param argument null
     * @return The result of a request to list events for a webhook.
     */
    public suspend fun listWebhookEvents(argument: ListWebhookEventsPlainArgs): ListWebhookEventsResult =
        listWebhookEventsResultToKotlin(listWebhookEventsPlain(argument.toJava()).await())

    /**
     * @see [listWebhookEvents].
     * @param registryName The name of the container registry.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param webhookName The name of the webhook.
     * @return The result of a request to list events for a webhook.
     */
    public suspend fun listWebhookEvents(
        registryName: String,
        resourceGroupName: String,
        webhookName: String,
    ): ListWebhookEventsResult {
        val argument = ListWebhookEventsPlainArgs(
            registryName = registryName,
            resourceGroupName = resourceGroupName,
            webhookName = webhookName,
        )
        return listWebhookEventsResultToKotlin(listWebhookEventsPlain(argument.toJava()).await())
    }

    /**
     * @see [listWebhookEvents].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;containerregistry&#46;kotlin&#46;inputs&#46;ListWebhookEventsPlainArgs].
     * @return The result of a request to list events for a webhook.
     */
    public suspend fun listWebhookEvents(argument: suspend ListWebhookEventsPlainArgsBuilder.() -> Unit): ListWebhookEventsResult {
        val builder = ListWebhookEventsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWebhookEventsResultToKotlin(listWebhookEventsPlain(builtArgument.toJava()).await())
    }
}
