@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.RegistryArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.NetworkRuleBypassOptions
import com.pulumi.azurenative.containerregistry.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.containerregistry.kotlin.enums.ZoneRedundancy
import com.pulumi.azurenative.containerregistry.kotlin.inputs.EncryptionPropertyArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.EncryptionPropertyArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.NetworkRuleSetArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.NetworkRuleSetArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PoliciesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.PoliciesArgsBuilder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2017-03-01, 2019-05-01, 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### RegistryCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registry = new AzureNative.ContainerRegistry.Registry("registry", new()
 *     {
 *         AdminUserEnabled = true,
 *         Location = "westus",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.ContainerRegistry.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ContainerRegistry.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewRegistry(ctx, "registry", &containerregistry.RegistryArgs{
 * 			AdminUserEnabled:  pulumi.Bool(true),
 * 			Location:          pulumi.String("westus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &containerregistry.SkuArgs{
 * 				Name: pulumi.String(containerregistry.SkuNameStandard),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Registry;
 * import com.pulumi.azurenative.containerregistry.RegistryArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registry = new Registry("registry", RegistryArgs.builder()
 *             .adminUserEnabled(true)
 *             .location("westus")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### RegistryCreateZoneRedundant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registry = new AzureNative.ContainerRegistry.Registry("registry", new()
 *     {
 *         Location = "westus",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.ContainerRegistry.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.ContainerRegistry.SkuName.Standard,
 *         },
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         ZoneRedundancy = AzureNative.ContainerRegistry.ZoneRedundancy.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewRegistry(ctx, "registry", &containerregistry.RegistryArgs{
 * 			Location:          pulumi.String("westus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &containerregistry.SkuArgs{
 * 				Name: pulumi.String(containerregistry.SkuNameStandard),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			ZoneRedundancy: pulumi.String(containerregistry.ZoneRedundancyEnabled),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Registry;
 * import com.pulumi.azurenative.containerregistry.RegistryArgs;
 * import com.pulumi.azurenative.containerregistry.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registry = new Registry("registry", RegistryArgs.builder()
 *             .location("westus")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .sku(SkuArgs.builder()
 *                 .name("Standard")
 *                 .build())
 *             .tags(Map.of("key", "value"))
 *             .zoneRedundancy("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Registry myRegistry /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}
 * ```
 * @property adminUserEnabled The value that indicates whether the admin user is enabled.
 * @property dataEndpointEnabled Enable a single data endpoint per region for serving data.
 * @property encryption The encryption settings of container registry.
 * @property identity The identity of the container registry.
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property networkRuleBypassOptions Whether to allow trusted Azure services to access a network restricted registry.
 * @property networkRuleSet The network rule set for a container registry.
 * @property policies The policies for a container registry.
 * @property publicNetworkAccess Whether or not public network access is allowed for the container registry.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU of the container registry.
 * @property tags The tags of the resource.
 * @property zoneRedundancy Whether or not zone redundancy is enabled for this container registry
 */
public data class RegistryArgs(
    public val adminUserEnabled: Output<Boolean>? = null,
    public val dataEndpointEnabled: Output<Boolean>? = null,
    public val encryption: Output<EncryptionPropertyArgs>? = null,
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val networkRuleBypassOptions: Output<Either<String, NetworkRuleBypassOptions>>? = null,
    public val networkRuleSet: Output<NetworkRuleSetArgs>? = null,
    public val policies: Output<PoliciesArgs>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneRedundancy: Output<Either<String, ZoneRedundancy>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.RegistryArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.RegistryArgs =
        com.pulumi.azurenative.containerregistry.RegistryArgs.builder()
            .adminUserEnabled(adminUserEnabled?.applyValue({ args0 -> args0 }))
            .dataEndpointEnabled(dataEndpointEnabled?.applyValue({ args0 -> args0 }))
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .networkRuleBypassOptions(
                networkRuleBypassOptions?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .networkRuleSet(networkRuleSet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .policies(policies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneRedundancy(
                zoneRedundancy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RegistryArgs].
 */
@PulumiTagMarker
public class RegistryArgsBuilder internal constructor() {
    private var adminUserEnabled: Output<Boolean>? = null

    private var dataEndpointEnabled: Output<Boolean>? = null

    private var encryption: Output<EncryptionPropertyArgs>? = null

    private var identity: Output<IdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var networkRuleBypassOptions: Output<Either<String, NetworkRuleBypassOptions>>? = null

    private var networkRuleSet: Output<NetworkRuleSetArgs>? = null

    private var policies: Output<PoliciesArgs>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneRedundancy: Output<Either<String, ZoneRedundancy>>? = null

    /**
     * @param value The value that indicates whether the admin user is enabled.
     */
    @JvmName("peowbvdemdtknbal")
    public suspend fun adminUserEnabled(`value`: Output<Boolean>) {
        this.adminUserEnabled = value
    }

    /**
     * @param value Enable a single data endpoint per region for serving data.
     */
    @JvmName("ijukrssfkvuwtoke")
    public suspend fun dataEndpointEnabled(`value`: Output<Boolean>) {
        this.dataEndpointEnabled = value
    }

    /**
     * @param value The encryption settings of container registry.
     */
    @JvmName("fjigfgwaboetoygs")
    public suspend fun encryption(`value`: Output<EncryptionPropertyArgs>) {
        this.encryption = value
    }

    /**
     * @param value The identity of the container registry.
     */
    @JvmName("wpxjysnbfxydewqy")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("tretawxdkspxwafv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Whether to allow trusted Azure services to access a network restricted registry.
     */
    @JvmName("ayvqulilvjtvkggk")
    public suspend fun networkRuleBypassOptions(`value`: Output<Either<String, NetworkRuleBypassOptions>>) {
        this.networkRuleBypassOptions = value
    }

    /**
     * @param value The network rule set for a container registry.
     */
    @JvmName("wsacgmjwktaehlrq")
    public suspend fun networkRuleSet(`value`: Output<NetworkRuleSetArgs>) {
        this.networkRuleSet = value
    }

    /**
     * @param value The policies for a container registry.
     */
    @JvmName("mfhbfxtsogkrucdp")
    public suspend fun policies(`value`: Output<PoliciesArgs>) {
        this.policies = value
    }

    /**
     * @param value Whether or not public network access is allowed for the container registry.
     */
    @JvmName("aylqymoqdcptllwg")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("rnvvgpaqpwqtgoio")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fdcbrpyvjehivknq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU of the container registry.
     */
    @JvmName("qrgaybsymuywndpx")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("dxfiufvwkceeeyuy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry
     */
    @JvmName("ouuqlajjstbeolyf")
    public suspend fun zoneRedundancy(`value`: Output<Either<String, ZoneRedundancy>>) {
        this.zoneRedundancy = value
    }

    /**
     * @param value The value that indicates whether the admin user is enabled.
     */
    @JvmName("sutydgpibghytuug")
    public suspend fun adminUserEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserEnabled = mapped
    }

    /**
     * @param value Enable a single data endpoint per region for serving data.
     */
    @JvmName("rmpfdnoyehgdtrdh")
    public suspend fun dataEndpointEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataEndpointEnabled = mapped
    }

    /**
     * @param value The encryption settings of container registry.
     */
    @JvmName("hwucoixnfnrdpmnb")
    public suspend fun encryption(`value`: EncryptionPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The encryption settings of container registry.
     */
    @JvmName("hgcsnsmwtfkcehrb")
    public suspend fun encryption(argument: suspend EncryptionPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value The identity of the container registry.
     */
    @JvmName("ptojqevbcxkkuhpy")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the container registry.
     */
    @JvmName("xcvqvmvtliojkwmj")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("gwhcjncalejilrjo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Whether to allow trusted Azure services to access a network restricted registry.
     */
    @JvmName("glwecxpcjtvusyre")
    public suspend fun networkRuleBypassOptions(`value`: Either<String, NetworkRuleBypassOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleBypassOptions = mapped
    }

    /**
     * @param value Whether to allow trusted Azure services to access a network restricted registry.
     */
    @JvmName("ijmpgrcyorljdqcv")
    public fun networkRuleBypassOptions(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkRuleBypassOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkRuleBypassOptions = mapped
    }

    /**
     * @param value Whether to allow trusted Azure services to access a network restricted registry.
     */
    @JvmName("waohgddesoaxffbu")
    public fun networkRuleBypassOptions(`value`: NetworkRuleBypassOptions) {
        val toBeMapped = Either.ofRight<String, NetworkRuleBypassOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkRuleBypassOptions = mapped
    }

    /**
     * @param value The network rule set for a container registry.
     */
    @JvmName("koqenbtflrgrejqj")
    public suspend fun networkRuleSet(`value`: NetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleSet = mapped
    }

    /**
     * @param argument The network rule set for a container registry.
     */
    @JvmName("caiofjjcsytqdncy")
    public suspend fun networkRuleSet(argument: suspend NetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkRuleSet = mapped
    }

    /**
     * @param value The policies for a container registry.
     */
    @JvmName("kveiypxloauksypa")
    public suspend fun policies(`value`: PoliciesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param argument The policies for a container registry.
     */
    @JvmName("lqugjmyhrkhilmst")
    public suspend fun policies(argument: suspend PoliciesArgsBuilder.() -> Unit) {
        val toBeMapped = PoliciesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policies = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for the container registry.
     */
    @JvmName("umkjfstotbwlcmwl")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for the container registry.
     */
    @JvmName("arsbwxnloalhrugd")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for the container registry.
     */
    @JvmName("dsufevmdokqmtqgc")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("fmdabvwowhuhdhyj")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rtwvbscckqhabcxd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU of the container registry.
     */
    @JvmName("lplmruegpsklolvy")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the container registry.
     */
    @JvmName("mubviauemrrokdtt")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("ooynfokxfruttfhd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("ffejcycblxntdtrt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry
     */
    @JvmName("mwtplcilraylcoec")
    public suspend fun zoneRedundancy(`value`: Either<String, ZoneRedundancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry
     */
    @JvmName("hpwcmqjljtxnfrra")
    public fun zoneRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ZoneRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value Whether or not zone redundancy is enabled for this container registry
     */
    @JvmName("yfobwfmfcdgraoxr")
    public fun zoneRedundancy(`value`: ZoneRedundancy) {
        val toBeMapped = Either.ofRight<String, ZoneRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    internal fun build(): RegistryArgs = RegistryArgs(
        adminUserEnabled = adminUserEnabled,
        dataEndpointEnabled = dataEndpointEnabled,
        encryption = encryption,
        identity = identity,
        location = location,
        networkRuleBypassOptions = networkRuleBypassOptions,
        networkRuleSet = networkRuleSet,
        policies = policies,
        publicNetworkAccess = publicNetworkAccess,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zoneRedundancy = zoneRedundancy,
    )
}
