@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.containerregistry.kotlin.outputs.StatusResponse.Companion.toKotlin as statusResponseToKotlin
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Replication].
 */
@PulumiTagMarker
public class ReplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationArgs = ReplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationArgsBuilder.() -> Unit) {
        val builder = ReplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Replication {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.Replication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Replication(builtJavaResource)
    }
}

/**
 * An object that represents a replication for a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ReplicationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replication = new AzureNative.ContainerRegistry.Replication("replication", new()
 *     {
 *         Location = "eastus",
 *         RegistryName = "myRegistry",
 *         ReplicationName = "myReplication",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewReplication(ctx, "replication", &containerregistry.ReplicationArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ReplicationName:   pulumi.String("myReplication"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Replication;
 * import com.pulumi.azurenative.containerregistry.ReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replication = new Replication("replication", ReplicationArgs.builder()
 *             .location("eastus")
 *             .registryName("myRegistry")
 *             .replicationName("myReplication")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key", "value"))
 *             .build());
 *     }
 * }
 * ```
 * ### ReplicationCreateZoneRedundant
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replication = new AzureNative.ContainerRegistry.Replication("replication", new()
 *     {
 *         Location = "eastus",
 *         RegionEndpointEnabled = true,
 *         RegistryName = "myRegistry",
 *         ReplicationName = "myReplication",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         ZoneRedundancy = AzureNative.ContainerRegistry.ZoneRedundancy.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewReplication(ctx, "replication", &containerregistry.ReplicationArgs{
 * 			Location:              pulumi.String("eastus"),
 * 			RegionEndpointEnabled: pulumi.Bool(true),
 * 			RegistryName:          pulumi.String("myRegistry"),
 * 			ReplicationName:       pulumi.String("myReplication"),
 * 			ResourceGroupName:     pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			ZoneRedundancy: pulumi.String(containerregistry.ZoneRedundancyEnabled),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Replication;
 * import com.pulumi.azurenative.containerregistry.ReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replication = new Replication("replication", ReplicationArgs.builder()
 *             .location("eastus")
 *             .regionEndpointEnabled(true)
 *             .registryName("myRegistry")
 *             .replicationName("myReplication")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("key", "value"))
 *             .zoneRedundancy("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Replication myReplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/replications/{replicationName}
 * ```
 */
public class Replication internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.Replication,
) : KotlinCustomResource(javaResource, ReplicationMapper) {
    /**
     * The location of the resource. This cannot be changed after the resource is created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the replication at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue to be synced with other replications.
     */
    public val regionEndpointEnabled: Output<Boolean>?
        get() = javaResource.regionEndpointEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the replication at the time the operation was called.
     */
    public val status: Output<StatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                statusResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether or not zone redundancy is enabled for this container registry replication
     */
    public val zoneRedundancy: Output<String>?
        get() = javaResource.zoneRedundancy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ReplicationMapper : ResourceMapper<Replication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.Replication::class == javaResource::class

    override fun map(javaResource: Resource): Replication = Replication(
        javaResource as
            com.pulumi.azurenative.containerregistry.Replication,
    )
}

/**
 * @see [Replication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Replication].
 */
public suspend fun replication(name: String, block: suspend ReplicationResourceBuilder.() -> Unit): Replication {
    val builder = ReplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Replication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replication(name: String): Replication {
    val builder = ReplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
