@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ScopeMap].
 */
@PulumiTagMarker
public class ScopeMapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScopeMapArgs = ScopeMapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScopeMapArgsBuilder.() -> Unit) {
        val builder = ScopeMapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ScopeMap {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.ScopeMap(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ScopeMap(builtJavaResource)
    }
}

/**
 * An object that represents a scope map for a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### ScopeMapCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeMap = new AzureNative.ContainerRegistry.ScopeMap("scopeMap", new()
 *     {
 *         Actions = new[]
 *         {
 *             "repositories/myrepository/contentWrite",
 *             "repositories/myrepository/delete",
 *         },
 *         Description = "Developer Scopes",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         ScopeMapName = "myScopeMap",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewScopeMap(ctx, "scopeMap", &containerregistry.ScopeMapArgs{
 * 			Actions: pulumi.StringArray{
 * 				pulumi.String("repositories/myrepository/contentWrite"),
 * 				pulumi.String("repositories/myrepository/delete"),
 * 			},
 * 			Description:       pulumi.String("Developer Scopes"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ScopeMapName:      pulumi.String("myScopeMap"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.ScopeMap;
 * import com.pulumi.azurenative.containerregistry.ScopeMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeMap = new ScopeMap("scopeMap", ScopeMapArgs.builder()
 *             .actions(
 *                 "repositories/myrepository/contentWrite",
 *                 "repositories/myrepository/delete")
 *             .description("Developer Scopes")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .scopeMapName("myScopeMap")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:ScopeMap myScopeMap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/scopeMaps/{scopeMapName}
 * ```
 */
public class ScopeMap internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.ScopeMap,
) : KotlinCustomResource(javaResource, ScopeMapMapper) {
    /**
     * The list of scoped permissions for registry artifacts.
     * E.g. repositories/repository-name/content/read,
     * repositories/repository-name/metadata/write
     */
    public val actions: Output<List<String>>
        get() = javaResource.actions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The creation date of scope map.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The user friendly description of the scope map.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ScopeMapMapper : ResourceMapper<ScopeMap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.ScopeMap::class == javaResource::class

    override fun map(javaResource: Resource): ScopeMap = ScopeMap(
        javaResource as
            com.pulumi.azurenative.containerregistry.ScopeMap,
    )
}

/**
 * @see [ScopeMap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ScopeMap].
 */
public suspend fun scopeMap(name: String, block: suspend ScopeMapResourceBuilder.() -> Unit): ScopeMap {
    val builder = ScopeMapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ScopeMap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun scopeMap(name: String): ScopeMap {
    val builder = ScopeMapResourceBuilder()
    builder.name(name)
    return builder.build()
}
