@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.TaskRunArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgs
import com.pulumi.azurenative.containerregistry.kotlin.inputs.IdentityPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The task run that has the ARM resource and properties.
 * The task run will have the information of request and result of a run.
 * Azure REST API version: 2019-06-01-preview. Prior API version in Azure Native 1.x: 2019-06-01-preview.
 * ## Example Usage
 * ### TaskRuns_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var taskRun = new AzureNative.ContainerRegistry.TaskRun("taskRun", new()
 *     {
 *         ForceUpdateTag = "test",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         RunRequest = new AzureNative.ContainerRegistry.Inputs.EncodedTaskRunRequestArgs
 *         {
 *             Credentials = null,
 *             EncodedTaskContent = "c3RlcHM6IAogIC0gY21kOiB7eyAuVmFsdWVzLmNvbW1hbmQgfX0K",
 *             EncodedValuesContent = "Y29tbWFuZDogYmFzaCBlY2hvIHt7LlJ1bi5SZWdpc3RyeX19Cg==",
 *             Platform = new AzureNative.ContainerRegistry.Inputs.PlatformPropertiesArgs
 *             {
 *                 Architecture = AzureNative.ContainerRegistry.Architecture.Amd64,
 *                 Os = AzureNative.ContainerRegistry.OS.Linux,
 *             },
 *             Type = "EncodedTaskRunRequest",
 *             Values = new() { },
 *         },
 *         TaskRunName = "myRun",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewTaskRun(ctx, "taskRun", &containerregistry.TaskRunArgs{
 * 			ForceUpdateTag:    pulumi.String("test"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RunRequest: containerregistry.EncodedTaskRunRequest{
 * 				Credentials:          nil,
 * 				EncodedTaskContent:   "c3RlcHM6IAogIC0gY21kOiB7eyAuVmFsdWVzLmNvbW1hbmQgfX0K",
 * 				EncodedValuesContent: "Y29tbWFuZDogYmFzaCBlY2hvIHt7LlJ1bi5SZWdpc3RyeX19Cg==",
 * 				Platform: containerregistry.PlatformProperties{
 * 					Architecture: containerregistry.ArchitectureAmd64,
 * 					Os:           containerregistry.OSLinux,
 * 				},
 * 				Type:   "EncodedTaskRunRequest",
 * 				Values: []containerregistry.SetValue{},
 * 			},
 * 			TaskRunName: pulumi.String("myRun"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.TaskRun;
 * import com.pulumi.azurenative.containerregistry.TaskRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var taskRun = new TaskRun("taskRun", TaskRunArgs.builder()
 *             .forceUpdateTag("test")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .runRequest(EncodedTaskRunRequestArgs.builder()
 *                 .credentials()
 *                 .encodedTaskContent("c3RlcHM6IAogIC0gY21kOiB7eyAuVmFsdWVzLmNvbW1hbmQgfX0K")
 *                 .encodedValuesContent("Y29tbWFuZDogYmFzaCBlY2hvIHt7LlJ1bi5SZWdpc3RyeX19Cg==")
 *                 .platform(PlatformPropertiesArgs.builder()
 *                     .architecture("amd64")
 *                     .os("Linux")
 *                     .build())
 *                 .type("EncodedTaskRunRequest")
 *                 .values()
 *                 .build())
 *             .taskRunName("myRun")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:TaskRun myrun /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/taskRuns/{taskRunName}
 * ```
 * @property forceUpdateTag How the run should be forced to rerun even if the run request configuration has not changed
 * @property identity Identity for the resource.
 * @property location The location of the resource
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group to which the container registry belongs.
 * @property runRequest The request (parameters) for the run
 * @property taskRunName The name of the task run.
 */
public data class TaskRunArgs(
    public val forceUpdateTag: Output<String>? = null,
    public val identity: Output<IdentityPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val runRequest: Output<Any>? = null,
    public val taskRunName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.TaskRunArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.TaskRunArgs =
        com.pulumi.azurenative.containerregistry.TaskRunArgs.builder()
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .runRequest(runRequest?.applyValue({ args0 -> args0 }))
            .taskRunName(taskRunName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TaskRunArgs].
 */
@PulumiTagMarker
public class TaskRunArgsBuilder internal constructor() {
    private var forceUpdateTag: Output<String>? = null

    private var identity: Output<IdentityPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var runRequest: Output<Any>? = null

    private var taskRunName: Output<String>? = null

    /**
     * @param value How the run should be forced to rerun even if the run request configuration has not changed
     */
    @JvmName("vaephoftdxhqavij")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("imhmivtmjluqsdsx")
    public suspend fun identity(`value`: Output<IdentityPropertiesArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of the resource
     */
    @JvmName("vrcagswpwqhymlhw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("agxpinoflttkoacs")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("qnduhpwykitbotqm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The request (parameters) for the run
     */
    @JvmName("eqhevcidohmkuxwq")
    public suspend fun runRequest(`value`: Output<Any>) {
        this.runRequest = value
    }

    /**
     * @param value The name of the task run.
     */
    @JvmName("kwhliptsbvwvunvs")
    public suspend fun taskRunName(`value`: Output<String>) {
        this.taskRunName = value
    }

    /**
     * @param value How the run should be forced to rerun even if the run request configuration has not changed
     */
    @JvmName("icmrbgxoguubmofj")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("pdwidsrjaeliaiap")
    public suspend fun identity(`value`: IdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("socbmhxkocwenjtn")
    public suspend fun identity(argument: suspend IdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of the resource
     */
    @JvmName("ewvrfwrwjnjkqtnh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("uukvadtiaxyqfnui")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group to which the container registry belongs.
     */
    @JvmName("gfmnpiwcrulcrdct")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The request (parameters) for the run
     */
    @JvmName("vswcnoujihylkvmd")
    public suspend fun runRequest(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runRequest = mapped
    }

    /**
     * @param value The name of the task run.
     */
    @JvmName("bipwdfvboxlubpso")
    public suspend fun taskRunName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskRunName = mapped
    }

    internal fun build(): TaskRunArgs = TaskRunArgs(
        forceUpdateTag = forceUpdateTag,
        identity = identity,
        location = location,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        runRequest = runRequest,
        taskRunName = taskRunName,
    )
}
