@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin

import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.containerregistry.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Webhook].
 */
@PulumiTagMarker
public class WebhookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebhookArgs = WebhookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebhookArgsBuilder.() -> Unit) {
        val builder = WebhookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Webhook {
        val builtJavaResource =
            com.pulumi.azurenative.containerregistry.Webhook(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Webhook(builtJavaResource)
    }
}

/**
 * An object that represents a webhook for a container registry.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2023-01-01-preview, 2023-06-01-preview, 2023-07-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### WebhookCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webhook = new AzureNative.ContainerRegistry.Webhook("webhook", new()
 *     {
 *         Actions = new[]
 *         {
 *             AzureNative.ContainerRegistry.WebhookAction.Push,
 *         },
 *         CustomHeaders =
 *         {
 *             { "Authorization", "******" },
 *         },
 *         Location = "westus",
 *         RegistryName = "myRegistry",
 *         ResourceGroupName = "myResourceGroup",
 *         Scope = "myRepository",
 *         ServiceUri = "http://myservice.com",
 *         Status = AzureNative.ContainerRegistry.WebhookStatus.Enabled,
 *         Tags =
 *         {
 *             { "key", "value" },
 *         },
 *         WebhookName = "myWebhook",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/containerregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := containerregistry.NewWebhook(ctx, "webhook", &containerregistry.WebhookArgs{
 * 			Actions: pulumi.StringArray{
 * 				pulumi.String(containerregistry.WebhookActionPush),
 * 			},
 * 			CustomHeaders: pulumi.StringMap{
 * 				"Authorization": pulumi.String("******"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			RegistryName:      pulumi.String("myRegistry"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Scope:             pulumi.String("myRepository"),
 * 			ServiceUri:        pulumi.String("http://myservice.com"),
 * 			Status:            pulumi.String(containerregistry.WebhookStatusEnabled),
 * 			Tags: pulumi.StringMap{
 * 				"key": pulumi.String("value"),
 * 			},
 * 			WebhookName: pulumi.String("myWebhook"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.containerregistry.Webhook;
 * import com.pulumi.azurenative.containerregistry.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webhook = new Webhook("webhook", WebhookArgs.builder()
 *             .actions("push")
 *             .customHeaders(Map.of("Authorization", "******"))
 *             .location("westus")
 *             .registryName("myRegistry")
 *             .resourceGroupName("myResourceGroup")
 *             .scope("myRepository")
 *             .serviceUri("http://myservice.com")
 *             .status("enabled")
 *             .tags(Map.of("key", "value"))
 *             .webhookName("myWebhook")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:containerregistry:Webhook myWebhook /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/webhooks/{webhookName}
 * ```
 */
public class Webhook internal constructor(
    override val javaResource: com.pulumi.azurenative.containerregistry.Webhook,
) : KotlinCustomResource(javaResource, WebhookMapper) {
    /**
     * The list of actions that trigger the webhook to post notifications.
     */
    public val actions: Output<List<String>>
        get() = javaResource.actions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The location of the resource. This cannot be changed after the resource is created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the webhook at the time the operation was called.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
     */
    public val scope: Output<String>?
        get() = javaResource.scope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the webhook at the time the operation was called.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebhookMapper : ResourceMapper<Webhook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.containerregistry.Webhook::class == javaResource::class

    override fun map(javaResource: Resource): Webhook = Webhook(
        javaResource as
            com.pulumi.azurenative.containerregistry.Webhook,
    )
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Webhook].
 */
public suspend fun webhook(name: String, block: suspend WebhookResourceBuilder.() -> Unit): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webhook(name: String): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    return builder.build()
}
