@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The OS architecture.
 */
public enum class Architecture(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.Architecture,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.Architecture> {
    Amd64(com.pulumi.azurenative.containerregistry.enums.Architecture.Amd64),
    X86(com.pulumi.azurenative.containerregistry.enums.Architecture.X86),
    _386(com.pulumi.azurenative.containerregistry.enums.Architecture._386),
    Arm(com.pulumi.azurenative.containerregistry.enums.Architecture.Arm),
    Arm64(com.pulumi.azurenative.containerregistry.enums.Architecture.Arm64),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.Architecture = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.Architecture): Architecture = Architecture.values().first { it.javaValue == javaType }
    }
}
