@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The private link service connection status.
 */
public enum class ConnectionStatus(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.ConnectionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.ConnectionStatus> {
    Approved(com.pulumi.azurenative.containerregistry.enums.ConnectionStatus.Approved),
    Pending(com.pulumi.azurenative.containerregistry.enums.ConnectionStatus.Pending),
    Rejected(com.pulumi.azurenative.containerregistry.enums.ConnectionStatus.Rejected),
    Disconnected(com.pulumi.azurenative.containerregistry.enums.ConnectionStatus.Disconnected),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.ConnectionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.ConnectionStatus): ConnectionStatus = ConnectionStatus.values().first { it.javaValue == javaType }
    }
}
