@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The verbosity of logs persisted on the connected registry.
 */
public enum class LogLevel(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.LogLevel,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.LogLevel> {
    Debug(com.pulumi.azurenative.containerregistry.enums.LogLevel.Debug),
    Information(com.pulumi.azurenative.containerregistry.enums.LogLevel.Information),
    Warning(com.pulumi.azurenative.containerregistry.enums.LogLevel.Warning),
    Error(com.pulumi.azurenative.containerregistry.enums.LogLevel.Error),
    None(com.pulumi.azurenative.containerregistry.enums.LogLevel.None),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.LogLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.LogLevel): LogLevel = LogLevel.values().first { it.javaValue == javaType }
    }
}
