@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The operating system type required for the run.
 */
public enum class OS(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.OS,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.OS> {
    Windows(com.pulumi.azurenative.containerregistry.enums.OS.Windows),
    Linux(com.pulumi.azurenative.containerregistry.enums.OS.Linux),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.OS = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.OS): OS =
            OS.values().first { it.javaValue == javaType }
    }
}
