@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of the secret object which determines how the value of the secret object has to be
 * interpreted.
 */
public enum class SecretObjectType(
    public val javaValue: com.pulumi.azurenative.containerregistry.enums.SecretObjectType,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.enums.SecretObjectType> {
    Opaque(com.pulumi.azurenative.containerregistry.enums.SecretObjectType.Opaque),
    Vaultsecret(com.pulumi.azurenative.containerregistry.enums.SecretObjectType.Vaultsecret),
    ;

    override fun toJava(): com.pulumi.azurenative.containerregistry.enums.SecretObjectType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.containerregistry.enums.SecretObjectType): SecretObjectType = SecretObjectType.values().first { it.javaValue == javaType }
    }
}
