@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.AuthCredentialArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.CredentialName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authentication credential stored for an upstream.
 * @property name The name of the credential.
 * @property passwordSecretIdentifier KeyVault Secret URI for accessing the password.
 * @property usernameSecretIdentifier KeyVault Secret URI for accessing the username.
 */
public data class AuthCredentialArgs(
    public val name: Output<Either<String, CredentialName>>? = null,
    public val passwordSecretIdentifier: Output<String>? = null,
    public val usernameSecretIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.AuthCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.AuthCredentialArgs =
        com.pulumi.azurenative.containerregistry.inputs.AuthCredentialArgs.builder()
            .name(
                name?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .passwordSecretIdentifier(passwordSecretIdentifier?.applyValue({ args0 -> args0 }))
            .usernameSecretIdentifier(usernameSecretIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthCredentialArgs].
 */
@PulumiTagMarker
public class AuthCredentialArgsBuilder internal constructor() {
    private var name: Output<Either<String, CredentialName>>? = null

    private var passwordSecretIdentifier: Output<String>? = null

    private var usernameSecretIdentifier: Output<String>? = null

    /**
     * @param value The name of the credential.
     */
    @JvmName("seboulmxqprtkspq")
    public suspend fun name(`value`: Output<Either<String, CredentialName>>) {
        this.name = value
    }

    /**
     * @param value KeyVault Secret URI for accessing the password.
     */
    @JvmName("lekcngigsspagywu")
    public suspend fun passwordSecretIdentifier(`value`: Output<String>) {
        this.passwordSecretIdentifier = value
    }

    /**
     * @param value KeyVault Secret URI for accessing the username.
     */
    @JvmName("lqgipvrgvtdusarl")
    public suspend fun usernameSecretIdentifier(`value`: Output<String>) {
        this.usernameSecretIdentifier = value
    }

    /**
     * @param value The name of the credential.
     */
    @JvmName("lwkrrbyddneblisn")
    public suspend fun name(`value`: Either<String, CredentialName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the credential.
     */
    @JvmName("lqylnwrdtvxgkppa")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CredentialName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the credential.
     */
    @JvmName("qpppibdppkyeifcx")
    public fun name(`value`: CredentialName) {
        val toBeMapped = Either.ofRight<String, CredentialName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value KeyVault Secret URI for accessing the password.
     */
    @JvmName("eunmxefddbrwketp")
    public suspend fun passwordSecretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordSecretIdentifier = mapped
    }

    /**
     * @param value KeyVault Secret URI for accessing the username.
     */
    @JvmName("eibqqwffyfarbuuh")
    public suspend fun usernameSecretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameSecretIdentifier = mapped
    }

    internal fun build(): AuthCredentialArgs = AuthCredentialArgs(
        name = name,
        passwordSecretIdentifier = passwordSecretIdentifier,
        usernameSecretIdentifier = usernameSecretIdentifier,
    )
}
