@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.AuthInfoArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.TokenType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The authorization properties for accessing the source code repository.
 * @property expiresIn Time in seconds that the token remains valid
 * @property refreshToken The refresh token used to refresh the access token.
 * @property scope The scope of the access token.
 * @property token The access token used to access the source control provider.
 * @property tokenType The type of Auth token.
 */
public data class AuthInfoArgs(
    public val expiresIn: Output<Int>? = null,
    public val refreshToken: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val token: Output<String>,
    public val tokenType: Output<Either<String, TokenType>>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.AuthInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.AuthInfoArgs =
        com.pulumi.azurenative.containerregistry.inputs.AuthInfoArgs.builder()
            .expiresIn(expiresIn?.applyValue({ args0 -> args0 }))
            .refreshToken(refreshToken?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .token(token.applyValue({ args0 -> args0 }))
            .tokenType(
                tokenType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [AuthInfoArgs].
 */
@PulumiTagMarker
public class AuthInfoArgsBuilder internal constructor() {
    private var expiresIn: Output<Int>? = null

    private var refreshToken: Output<String>? = null

    private var scope: Output<String>? = null

    private var token: Output<String>? = null

    private var tokenType: Output<Either<String, TokenType>>? = null

    /**
     * @param value Time in seconds that the token remains valid
     */
    @JvmName("toadaivlwffajmbd")
    public suspend fun expiresIn(`value`: Output<Int>) {
        this.expiresIn = value
    }

    /**
     * @param value The refresh token used to refresh the access token.
     */
    @JvmName("aqpscvkesqauiyej")
    public suspend fun refreshToken(`value`: Output<String>) {
        this.refreshToken = value
    }

    /**
     * @param value The scope of the access token.
     */
    @JvmName("btncswhnemesftmm")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The access token used to access the source control provider.
     */
    @JvmName("acbojwmtdrbbrpfu")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value The type of Auth token.
     */
    @JvmName("ggvfesmxcgqaucef")
    public suspend fun tokenType(`value`: Output<Either<String, TokenType>>) {
        this.tokenType = value
    }

    /**
     * @param value Time in seconds that the token remains valid
     */
    @JvmName("twibutpvvtqtofvw")
    public suspend fun expiresIn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresIn = mapped
    }

    /**
     * @param value The refresh token used to refresh the access token.
     */
    @JvmName("hedrayutctcsxieb")
    public suspend fun refreshToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The scope of the access token.
     */
    @JvmName("agpvvvumwcpvftlr")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The access token used to access the source control provider.
     */
    @JvmName("pnasapxglwoqyhvv")
    public suspend fun token(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value The type of Auth token.
     */
    @JvmName("nlvgbykakfuysipg")
    public suspend fun tokenType(`value`: Either<String, TokenType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenType = mapped
    }

    /**
     * @param value The type of Auth token.
     */
    @JvmName("qrkidwsahvqsojfw")
    public fun tokenType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TokenType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenType = mapped
    }

    /**
     * @param value The type of Auth token.
     */
    @JvmName("xoqpmurcigaqxukv")
    public fun tokenType(`value`: TokenType) {
        val toBeMapped = Either.ofRight<String, TokenType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenType = mapped
    }

    internal fun build(): AuthInfoArgs = AuthInfoArgs(
        expiresIn = expiresIn,
        refreshToken = refreshToken,
        scope = scope,
        token = token ?: throw PulumiNullFieldException("token"),
        tokenType = tokenType ?: throw PulumiNullFieldException("tokenType"),
    )
}
