@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.CustomRegistryCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the credentials that will be used to access a custom registry during a run.
 * @property identity Indicates the managed identity assigned to the custom credential. If a user-assigned identity
 * this value is the Client ID. If a system-assigned identity, the value will be `system`. In
 * the case of a system-assigned identity, the Client ID will be determined by the runner. This
 * identity may be used to authenticate to key vault to retrieve credentials or it may be the only
 * source of authentication used for accessing the registry.
 * @property password The password for logging into the custom registry. The password is a secret
 * object that allows multiple ways of providing the value for it.
 * @property userName The username for logging into the custom registry.
 */
public data class CustomRegistryCredentialsArgs(
    public val identity: Output<String>? = null,
    public val password: Output<SecretObjectArgs>? = null,
    public val userName: Output<SecretObjectArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.CustomRegistryCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.CustomRegistryCredentialsArgs =
        com.pulumi.azurenative.containerregistry.inputs.CustomRegistryCredentialsArgs.builder()
            .identity(identity?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userName(userName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CustomRegistryCredentialsArgs].
 */
@PulumiTagMarker
public class CustomRegistryCredentialsArgsBuilder internal constructor() {
    private var identity: Output<String>? = null

    private var password: Output<SecretObjectArgs>? = null

    private var userName: Output<SecretObjectArgs>? = null

    /**
     * @param value Indicates the managed identity assigned to the custom credential. If a user-assigned identity
     * this value is the Client ID. If a system-assigned identity, the value will be `system`. In
     * the case of a system-assigned identity, the Client ID will be determined by the runner. This
     * identity may be used to authenticate to key vault to retrieve credentials or it may be the only
     * source of authentication used for accessing the registry.
     */
    @JvmName("fwitgsvtsodabtxq")
    public suspend fun identity(`value`: Output<String>) {
        this.identity = value
    }

    /**
     * @param value The password for logging into the custom registry. The password is a secret
     * object that allows multiple ways of providing the value for it.
     */
    @JvmName("rnbyhsvtwpoqvrqv")
    public suspend fun password(`value`: Output<SecretObjectArgs>) {
        this.password = value
    }

    /**
     * @param value The username for logging into the custom registry.
     */
    @JvmName("dbklhbjkxrplbwvm")
    public suspend fun userName(`value`: Output<SecretObjectArgs>) {
        this.userName = value
    }

    /**
     * @param value Indicates the managed identity assigned to the custom credential. If a user-assigned identity
     * this value is the Client ID. If a system-assigned identity, the value will be `system`. In
     * the case of a system-assigned identity, the Client ID will be determined by the runner. This
     * identity may be used to authenticate to key vault to retrieve credentials or it may be the only
     * source of authentication used for accessing the registry.
     */
    @JvmName("ydsktmuanjekxobb")
    public suspend fun identity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value The password for logging into the custom registry. The password is a secret
     * object that allows multiple ways of providing the value for it.
     */
    @JvmName("debtbawvcyjdcaea")
    public suspend fun password(`value`: SecretObjectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument The password for logging into the custom registry. The password is a secret
     * object that allows multiple ways of providing the value for it.
     */
    @JvmName("yhfkmxvnxpbvrmdk")
    public suspend fun password(argument: suspend SecretObjectArgsBuilder.() -> Unit) {
        val toBeMapped = SecretObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value The username for logging into the custom registry.
     */
    @JvmName("jfpltfcpptlxnybu")
    public suspend fun userName(`value`: SecretObjectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param argument The username for logging into the custom registry.
     */
    @JvmName("yspekatvvrnnsyri")
    public suspend fun userName(argument: suspend SecretObjectArgsBuilder.() -> Unit) {
        val toBeMapped = SecretObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userName = mapped
    }

    internal fun build(): CustomRegistryCredentialsArgs = CustomRegistryCredentialsArgs(
        identity = identity,
        password = password,
        userName = userName,
    )
}
