@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetImportPipelinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property importPipelineName The name of the import pipeline.
 * @property registryName The name of the container registry.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetImportPipelinePlainArgs(
    public val importPipelineName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetImportPipelinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetImportPipelinePlainArgs = com.pulumi.azurenative.containerregistry.inputs.GetImportPipelinePlainArgs.builder()
        .importPipelineName(importPipelineName.let({ args0 -> args0 }))
        .registryName(registryName.let({ args0 -> args0 }))
        .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImportPipelinePlainArgs].
 */
@PulumiTagMarker
public class GetImportPipelinePlainArgsBuilder internal constructor() {
    private var importPipelineName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the import pipeline.
     */
    @JvmName("xbueauisjikjajkr")
    public suspend fun importPipelineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.importPipelineName = mapped
    }

    /**
     * @param value The name of the container registry.
     */
    @JvmName("dbenycmgbtnjngvp")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xkncwdejcfhwqfme")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetImportPipelinePlainArgs = GetImportPipelinePlainArgs(
        importPipelineName = importPipelineName ?: throw PulumiNullFieldException("importPipelineName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
