@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.GetReplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registryName The name of the container registry.
 * @property replicationName The name of the replication.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetReplicationPlainArgs(
    public val registryName: String,
    public val replicationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.GetReplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.GetReplicationPlainArgs =
        com.pulumi.azurenative.containerregistry.inputs.GetReplicationPlainArgs.builder()
            .registryName(registryName.let({ args0 -> args0 }))
            .replicationName(replicationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationPlainArgsBuilder internal constructor() {
    private var registryName: String? = null

    private var replicationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the container registry.
     */
    @JvmName("feimxltcfiqinxko")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the replication.
     */
    @JvmName("wdajbxvwtbivtfcf")
    public suspend fun replicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("muhqequapxellxbb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetReplicationPlainArgs = GetReplicationPlainArgs(
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        replicationName = replicationName ?: throw PulumiNullFieldException("replicationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
