@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.containerregistry.kotlin.inputs

import com.pulumi.azurenative.containerregistry.inputs.IPRuleArgs.builder
import com.pulumi.azurenative.containerregistry.kotlin.enums.Action
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IP rule with specific IP or IP range in CIDR format.
 * @property action The action of IP ACL rule.
 * @property iPAddressOrRange Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
 */
public data class IPRuleArgs(
    public val action: Output<Either<String, Action>>? = null,
    public val iPAddressOrRange: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.containerregistry.inputs.IPRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.containerregistry.inputs.IPRuleArgs =
        com.pulumi.azurenative.containerregistry.inputs.IPRuleArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .iPAddressOrRange(iPAddressOrRange.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPRuleArgs].
 */
@PulumiTagMarker
public class IPRuleArgsBuilder internal constructor() {
    private var action: Output<Either<String, Action>>? = null

    private var iPAddressOrRange: Output<String>? = null

    /**
     * @param value The action of IP ACL rule.
     */
    @JvmName("jhsridurbvgmucsc")
    public suspend fun action(`value`: Output<Either<String, Action>>) {
        this.action = value
    }

    /**
     * @param value Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
     */
    @JvmName("qyfebeyyxakoeaat")
    public suspend fun iPAddressOrRange(`value`: Output<String>) {
        this.iPAddressOrRange = value
    }

    /**
     * @param value The action of IP ACL rule.
     */
    @JvmName("clpkvvaermkjpquc")
    public suspend fun action(`value`: Either<String, Action>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The action of IP ACL rule.
     */
    @JvmName("hajurrpsiletgjmc")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The action of IP ACL rule.
     */
    @JvmName("coenyjvitbkmuwok")
    public fun action(`value`: Action) {
        val toBeMapped = Either.ofRight<String, Action>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
     */
    @JvmName("wnvrbkopjbxvemmt")
    public suspend fun iPAddressOrRange(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iPAddressOrRange = mapped
    }

    internal fun build(): IPRuleArgs = IPRuleArgs(
        action = action,
        iPAddressOrRange = iPAddressOrRange ?: throw PulumiNullFieldException("iPAddressOrRange"),
    )
}
